package gcp4s.bigquery.model

import _root_.gcp4s.json.given

final case class TrainingOptions(
  l2Regularization: Option[Double] = None,
  holidayRegion: Option["HOLIDAY_REGION_UNSPECIFIED" | "GLOBAL" | "NA" | "JAPAC" | "EMEA" | "LAC" | "AE" | "AR" | "AT" | "AU" | "BE" | "BR" | "CA" | "CH" | "CL" | "CN" | "CO" | "CS" | "CZ" | "DE" | "DK" | "DZ" | "EC" | "EE" | "EG" | "ES" | "FI" | "FR" | "GB" | "GR" | "HK" | "HU" | "ID" | "IE" | "IL" | "IN" | "IR" | "IT" | "JP" | "KR" | "LV" | "MA" | "MX" | "MY" | "NG" | "NL" | "NO" | "NZ" | "PE" | "PH" | "PK" | "PL" | "PT" | "RO" | "RS" | "RU" | "SA" | "SE" | "SG" | "SI" | "SK" | "TH" | "TR" | "TW" | "UA" | "US" | "VE" | "VN" | "ZA"] = None,
  timeSeriesDataColumn: Option[String] = None,
  initialLearnRate: Option[Double] = None,
  nonSeasonalOrder: Option[ArimaOrder] = None,
  batchSize: Option[Long] = None,
  horizon: Option[Long] = None,
  kmeansInitializationColumn: Option[String] = None,
  dataSplitMethod: Option["DATA_SPLIT_METHOD_UNSPECIFIED" | "RANDOM" | "CUSTOM" | "SEQUENTIAL" | "NO_SPLIT" | "AUTO_SPLIT"] = None,
  feedbackType: Option["FEEDBACK_TYPE_UNSPECIFIED" | "IMPLICIT" | "EXPLICIT"] = None,
  dropout: Option[Double] = None,
  minTreeChildWeight: Option[Long] = None,
  colsampleBylevel: Option[Double] = None,
  distanceType: Option["DISTANCE_TYPE_UNSPECIFIED" | "EUCLIDEAN" | "COSINE"] = None,
  subsample: Option[Double] = None,
  modelUri: Option[String] = None,
  dartNormalizeType: Option["DART_NORMALIZE_TYPE_UNSPECIFIED" | "TREE" | "FOREST"] = None,
  warmStart: Option[Boolean] = None,
  kmeansInitializationMethod: Option["KMEANS_INITIALIZATION_METHOD_UNSPECIFIED" | "RANDOM" | "CUSTOM" | "KMEANS_PLUS_PLUS"] = None,
  numClusters: Option[Long] = None,
  maxIterations: Option[Long] = None,
  timeSeriesIdColumn: Option[String] = None,
  userColumn: Option[String] = None,
  timeSeriesIdColumns: Option[List[String]] = None,
  preserveInputStructs: Option[Boolean] = None,
  itemColumn: Option[String] = None,
  adjustStepChanges: Option[Boolean] = None,
  inputLabelColumns: Option[List[String]] = None,
  boosterType: Option["BOOSTER_TYPE_UNSPECIFIED" | "GBTREE" | "DART"] = None,
  timeSeriesTimestampColumn: Option[String] = None,
  colsampleBynode: Option[Double] = None,
  walsAlpha: Option[Double] = None,
  learnRateStrategy: Option["LEARN_RATE_STRATEGY_UNSPECIFIED" | "LINE_SEARCH" | "CONSTANT"] = None,
  minSplitLoss: Option[Double] = None,
  learnRate: Option[Double] = None,
  l1Regularization: Option[Double] = None,
  numParallelTree: Option[Long] = None,
  numFactors: Option[Long] = None,
  colsampleBytree: Option[Double] = None,
  treeMethod: Option["TREE_METHOD_UNSPECIFIED" | "AUTO" | "EXACT" | "APPROX" | "HIST"] = None,
  earlyStop: Option[Boolean] = None,
  dataSplitEvalFraction: Option[Double] = None,
  dataFrequency: Option["DATA_FREQUENCY_UNSPECIFIED" | "AUTO_FREQUENCY" | "YEARLY" | "QUARTERLY" | "MONTHLY" | "WEEKLY" | "DAILY" | "HOURLY" | "PER_MINUTE"] = None,
  includeDrift: Option[Boolean] = None,
  minRelativeProgress: Option[Double] = None,
  autoArima: Option[Boolean] = None,
  dataSplitColumn: Option[String] = None,
  hiddenUnits: Option[List[Long]] = None,
  optimizationStrategy: Option["OPTIMIZATION_STRATEGY_UNSPECIFIED" | "BATCH_GRADIENT_DESCENT" | "NORMAL_EQUATION"] = None,
  cleanSpikesAndDips: Option[Boolean] = None,
  decomposeTimeSeries: Option[Boolean] = None,
  maxTreeDepth: Option[Long] = None,
  lossType: Option["LOSS_TYPE_UNSPECIFIED" | "MEAN_SQUARED_LOSS" | "MEAN_LOG_LOSS"] = None,
  labelClassWeights: Option[Map[String, Double]] = None,
  autoArimaMaxOrder: Option[Long] = None
) derives _root_.io.circe.Codec.AsObject

