/*
 * Decompiled with CFR 0.152.
 */
package com.armanbilge.scalanative.brew;

import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.scalanative.build.NativeConfig;

public final class BrewNativeConfig {
    private final Path cellar;
    private final List<ResolvedFormula> formulas;

    public BrewNativeConfig(Path cellar, List<ResolvedFormula> formulas) {
        this.cellar = cellar;
        this.formulas = formulas;
    }

    public NativeConfig apply(NativeConfig nativeConfig) {
        return nativeConfig.withCompileOptions((Seq)nativeConfig.compileOptions().$plus$plus(this.compileOptions())).withLinkingOptions((Seq)nativeConfig.linkingOptions().$plus$plus(this.linkingOptions()));
    }

    public List<String> compileOptions() {
        return this.includeDirs().map((Function1 & Serializable)p -> new StringBuilder(2).append("-I").append(p).toString());
    }

    public List<String> linkingOptions() {
        return this.libDirs().map((Function1 & Serializable)p -> new StringBuilder(2).append("-L").append(p).toString());
    }

    public String ldLibraryPath() {
        return this.libDirs().mkString(":");
    }

    private List<Path> dirs() {
        return this.formulas.map((Function1 & Serializable)_$1 -> _$1.locate(this.cellar));
    }

    private List<Path> includeDirs() {
        return this.dirs().map((Function1 & Serializable)_$2 -> _$2.resolve("include")).filter((Function1 & Serializable)_$3 -> _$3.toFile().exists());
    }

    private List<Path> libDirs() {
        return this.dirs().map((Function1 & Serializable)_$4 -> _$4.resolve("lib")).filter((Function1 & Serializable)_$5 -> _$5.toFile().exists());
    }

    public static final class ResolvedFormula {
        private final String name;
        private final String version;

        public ResolvedFormula(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public Path locate(Path cellar) {
            return cellar.resolve(this.name()).resolve(this.version());
        }
    }
}

