/*
 * Decompiled with CFR 0.152.
 */
package schrodinger.kernel.testkit;

import cats.kernel.Eq;
import cats.syntax.package;
import java.io.Serializable;
import org.apache.commons.math3.special.Gamma;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.deriving.Mirror;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import schrodinger.kernel.testkit.Confidence;
import schrodinger.kernel.testkit.EqUndecidableException;
import schrodinger.kernel.testkit.SimulationResult;
import schrodinger.math.LogDouble;
import schrodinger.math.LogDouble$package$;

public final class SimulationResult$
implements Mirror.Product,
Serializable {
    public static final SimulationResult$ MODULE$ = new SimulationResult$();

    private SimulationResult$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SimulationResult$.class);
    }

    public <A> SimulationResult<A> apply(List<A> samples) {
        return new SimulationResult<A>(samples);
    }

    public <A> SimulationResult<A> unapply(SimulationResult<A> x$1) {
        return x$1;
    }

    public String toString() {
        return "SimulationResult";
    }

    public final <A> Eq<SimulationResult<A>> given_Eq_SimulationResult(Eq<A> evidence$3, Confidence confidence) {
        return new Eq<SimulationResult<A>>(evidence$3, confidence){
            private final Eq evidence$3$9;
            private final Confidence confidence$4;
            {
                this.evidence$3$9 = evidence$3$10;
                this.confidence$4 = confidence$5;
            }

            public final boolean eqv(SimulationResult x$1, SimulationResult x$2) {
                return SimulationResult$.MODULE$.schrodinger$kernel$testkit$SimulationResult$$$_$given_Eq_SimulationResult$$anonfun$1(this.evidence$3$9, this.confidence$4, x$1, x$2);
            }
        };
    }

    private double equidistributedBelief(int[] trial1, int[] trial2, double[] dirichletPrior) {
        double d;
        LogDouble$package$ logDouble$package$;
        LogDouble$package$ logDouble$package$2;
        double marginal1 = this.dirichletMultinomialLogPmf(trial1, trial2, dirichletPrior);
        LogDouble$package$ LogDouble$package$_this = logDouble$package$2 = LogDouble$package$.MODULE$;
        double x$proxy1 = this.dirichletMultinomialLogPmf(trial1, dirichletPrior);
        double y$proxy1 = this.dirichletMultinomialLogPmf(trial2, dirichletPrior);
        double marginal2 = x$proxy1 + y$proxy1;
        LogDouble$package$ logDouble$package$3 = LogDouble$package$.MODULE$;
        LogDouble$package$ LogDouble$package$_this2 = logDouble$package$ = LogDouble$package$.MODULE$;
        double x$proxy4 = marginal1;
        LogDouble$package$ logDouble$package$4 = LogDouble$package$.MODULE$;
        LogDouble.package.LogDouble$ LogDouble$_this = LogDouble.package.LogDouble$.MODULE$;
        LogDouble$package$ LogDouble$package$_this3 = logDouble$package$4;
        double x$proxy2 = marginal1;
        double y$proxy2 = marginal2;
        if (x$proxy2 > y$proxy2) {
            d = Math.log1p(Math.exp(y$proxy2 - x$proxy2)) + x$proxy2;
        } else if (y$proxy2 > x$proxy2) {
            d = Math.log1p(Math.exp(x$proxy2 - y$proxy2)) + y$proxy2;
        } else {
            LogDouble$package$ logDouble$package$5;
            LogDouble$package$ logDouble$package$6 = logDouble$package$4;
            LogDouble$package$ LogDouble$package$_this4 = logDouble$package$5 = LogDouble$package$.MODULE$;
            double x$proxy3 = LogDouble$_this.Two();
            double y$proxy3 = x$proxy2;
            d = x$proxy3 + y$proxy3;
        }
        double y$proxy4 = d;
        double x$proxy5 = x$proxy4 - y$proxy4;
        return Math.exp(x$proxy5);
    }

    private double gamma(double x) {
        LogDouble$package$ logDouble$package$;
        LogDouble$package$ LogDouble$package$_this = logDouble$package$ = LogDouble$package$.MODULE$;
        double x$proxy6 = Gamma.logGamma((double)x);
        return x$proxy6;
    }

    private double dirichletMultinomialLogPmf(int[] x, double[] alpha) {
        LogDouble$package$ logDouble$package$;
        LogDouble$package$ logDouble$package$2;
        double A = this.sum(alpha);
        int n = this.sum(x);
        LogDouble$package$ LogDouble$package$_this = logDouble$package$2 = LogDouble$package$.MODULE$;
        LogDouble$package$ LogDouble$package$_this2 = logDouble$package$ = LogDouble$package$.MODULE$;
        double x$proxy7 = this.gamma(A);
        double y$proxy5 = this.gamma((double)n + 1.0);
        double x$proxy8 = x$proxy7 + y$proxy5;
        double y$proxy6 = this.gamma((double)n + A);
        double pmf = x$proxy8 - y$proxy6;
        for (int k = 0; k < x.length; ++k) {
            LogDouble$package$ logDouble$package$3;
            LogDouble$package$ logDouble$package$4;
            LogDouble$package$ logDouble$package$5;
            LogDouble$package$ LogDouble$package$_this3 = logDouble$package$5 = LogDouble$package$.MODULE$;
            double x$proxy11 = pmf;
            LogDouble$package$ LogDouble$package$_this4 = logDouble$package$4 = LogDouble$package$.MODULE$;
            LogDouble$package$ LogDouble$package$_this5 = logDouble$package$3 = LogDouble$package$.MODULE$;
            double x$proxy9 = this.gamma((double)x[k] + alpha[k]);
            double y$proxy7 = this.gamma(alpha[k]);
            double x$proxy10 = x$proxy9 - y$proxy7;
            double y$proxy8 = this.gamma((double)x[k] + 1.0);
            double y$proxy9 = x$proxy10 - y$proxy8;
            pmf = x$proxy11 + y$proxy9;
        }
        return pmf;
    }

    private double dirichletMultinomialLogPmf(int[] x1, int[] x2, double[] alpha) {
        LogDouble$package$ logDouble$package$;
        LogDouble$package$ logDouble$package$2;
        LogDouble$package$ logDouble$package$3;
        double A = this.sum(alpha);
        int n1 = this.sum(x1);
        int n2 = this.sum(x2);
        int n = n1 + n2;
        LogDouble$package$ LogDouble$package$_this = logDouble$package$3 = LogDouble$package$.MODULE$;
        LogDouble$package$ LogDouble$package$_this2 = logDouble$package$2 = LogDouble$package$.MODULE$;
        LogDouble$package$ LogDouble$package$_this3 = logDouble$package$ = LogDouble$package$.MODULE$;
        double x$proxy12 = this.gamma(A);
        double y$proxy10 = this.gamma((double)n1 + 1.0);
        double x$proxy13 = x$proxy12 + y$proxy10;
        double y$proxy11 = this.gamma((double)n2 + 1.0);
        double x$proxy14 = x$proxy13 + y$proxy11;
        double y$proxy12 = this.gamma((double)n + A);
        double pmf = x$proxy14 - y$proxy12;
        for (int k = 0; k < x1.length; ++k) {
            LogDouble$package$ logDouble$package$4;
            LogDouble$package$ logDouble$package$5;
            LogDouble$package$ logDouble$package$6;
            LogDouble$package$ logDouble$package$7;
            LogDouble$package$ LogDouble$package$_this4 = logDouble$package$7 = LogDouble$package$.MODULE$;
            double x$proxy18 = pmf;
            LogDouble$package$ LogDouble$package$_this5 = logDouble$package$6 = LogDouble$package$.MODULE$;
            LogDouble$package$ LogDouble$package$_this6 = logDouble$package$5 = LogDouble$package$.MODULE$;
            LogDouble$package$ LogDouble$package$_this7 = logDouble$package$4 = LogDouble$package$.MODULE$;
            double x$proxy15 = this.gamma((double)(x1[k] + x2[k]) + alpha[k]);
            double y$proxy13 = this.gamma(alpha[k]);
            double x$proxy16 = x$proxy15 - y$proxy13;
            double y$proxy14 = this.gamma((double)x1[k] + 1.0);
            double x$proxy17 = x$proxy16 - y$proxy14;
            double y$proxy15 = this.gamma((double)x2[k] + 1.0);
            double y$proxy16 = x$proxy17 - y$proxy15;
            pmf = x$proxy18 + y$proxy16;
        }
        return pmf;
    }

    /*
     * WARNING - void declaration
     */
    private int sum(int[] x) {
        void var3_3;
        int sum = 0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i];
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private double sum(double[] x) {
        void var3_3;
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i];
        }
        return (double)var3_3;
    }

    public SimulationResult<?> fromProduct(Product x$0) {
        return new SimulationResult((List)x$0.productElement(0));
    }

    private final Object a$3(Tuple2 x$1$1) {
        return x$1$1._1();
    }

    private final int i$1(Tuple2 x$1$2) {
        return BoxesRunTime.unboxToInt((Object)x$1$2._2());
    }

    private final double $anonfun$1() {
        return 1.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final /* synthetic */ boolean schrodinger$kernel$testkit$SimulationResult$$$_$given_Eq_SimulationResult$$anonfun$1(Eq evidence$3$2, Confidence confidence$3, SimulationResult x$12, SimulationResult x$2) {
        List list;
        List list2;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$12, (Object)x$2);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        SimulationResult simulationResult = (SimulationResult)tuple2._1();
        SimulationResult simulationResult2 = (SimulationResult)tuple2._2();
        if (simulationResult == null) throw new MatchError((Object)tuple2);
        SimulationResult simulationResult3 = this.unapply(simulationResult);
        List xs = list2 = simulationResult3._1();
        if (simulationResult2 == null) throw new MatchError((Object)tuple2);
        SimulationResult simulationResult4 = this.unapply(simulationResult2);
        List ys = list = simulationResult4._1();
        ArrayBuffer allValues = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        xs.foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (allValues.forall((Function1 & Serializable)_$4 -> package.all$.MODULE$.catsSyntaxEq(_$4, evidence$3$2).$eq$bang$eq(a))) {
                allValues.$plus$eq(a);
            }
        });
        ys.foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (allValues.forall((Function1 & Serializable)_$5 -> package.all$.MODULE$.catsSyntaxEq(_$5, evidence$3$2).$eq$bang$eq(a))) {
                allValues.$plus$eq(a);
            }
        });
        if (allValues.size() == 1) {
            return true;
        }
        int[] xcounts = new int[allValues.size()];
        int[] ycounts = new int[allValues.size()];
        ((IterableOnceOps)allValues.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            xcounts$1[this.i$1((Tuple2)x$1)] = xs.count((Function1 & Serializable)_$6 -> package.all$.MODULE$.catsSyntaxEq(_$6, evidence$3$2).$eq$eq$eq(this.a$3((Tuple2)x$1)));
            ycounts$1[this.i$1((Tuple2)x$1)] = ys.count((Function1 & Serializable)_$7 -> package.all$.MODULE$.catsSyntaxEq(_$7, evidence$3$2).$eq$eq$eq(this.a$3((Tuple2)x$1)));
        });
        double p = this.equidistributedBelief(xcounts, ycounts, (double[])Array$.MODULE$.fill(allValues.size(), this::$anonfun$1, ClassTag$.MODULE$.apply(Double.TYPE)));
        if (p > confidence$3.eqvThreshold()) {
            return true;
        }
        if (!(1.0 - p > confidence$3.neqvThreshold())) throw new EqUndecidableException();
        return false;
    }
}

