/*
 * Decompiled with CFR 0.152.
 */
package ars.database.hibernate;

import ars.database.hibernate.Hibernates;
import ars.database.repository.Query;
import ars.database.repository.Repositories;
import ars.util.Beans;
import ars.util.Conditions;
import ars.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.sql.JoinType;
import org.hibernate.type.Type;

public class DetachedCriteriaQuery<T>
implements Query<T> {
    private int page;
    private int size;
    private T object;
    private List<?> stats;
    private List<T> objects;
    private Integer count;
    private Class<T> model;
    private boolean loaded;
    private boolean subquery;
    private DetachedCriteria criteria;
    private SessionFactory sessionFactory;
    private List<String> orders = new LinkedList<String>();
    private ProjectionList projections = Projections.projectionList();
    private Map<String, String> aliases = new HashMap<String, String>();

    public DetachedCriteriaQuery(SessionFactory sessionFactory, Class<T> model) {
        if (sessionFactory == null) {
            throw new IllegalArgumentException("Illegal sessionFactory:" + sessionFactory);
        }
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        this.model = model;
        this.sessionFactory = sessionFactory;
        this.criteria = DetachedCriteria.forClass(model);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public DetachedCriteria getDetachedCriteria() {
        return this.criteria;
    }

    protected Criteria getExecutableCriteria(Session session) {
        if (this.subquery) {
            String primary = Repositories.getPrimary(this.getModel());
            this.criteria = DetachedCriteria.forClass(this.getModel()).add(Subqueries.propertyIn((String)primary, (DetachedCriteria)this.criteria.setProjection((Projection)Property.forName((String)primary))));
            this.aliases.clear();
        }
        for (String property : this.orders) {
            boolean asc = property.charAt(0) == '+';
            String alias = this.getCriteriaAlias(property.substring(1), JoinType.LEFT_OUTER_JOIN);
            if (asc) {
                this.criteria.addOrder(Order.asc((String)alias));
                continue;
            }
            this.criteria.addOrder(Order.desc((String)alias));
        }
        Criteria criteria = this.criteria.getExecutableCriteria(session).setResultTransformer(DetachedCriteria.ROOT_ENTITY);
        int index = (this.page - 1) * this.size;
        if (index > 0) {
            criteria.setFirstResult(index);
        }
        if (this.size > 0) {
            criteria.setMaxResults(this.size);
        }
        return criteria;
    }

    private String _getCriteriaAlias(String property, JoinType joinType) {
        String alias = this.aliases.get(property);
        if (alias == null) {
            int index = property.lastIndexOf(46);
            if (index <= 0) {
                alias = property + this.aliases.size();
                this.criteria.createAlias(property, alias, joinType);
            } else {
                alias = property.substring(index + 1) + this.aliases.size();
                this.criteria.createAlias(this._getCriteriaAlias(property.substring(0, index), joinType) + property.substring(index), alias);
            }
            this.aliases.put(property, alias);
        }
        return alias;
    }

    protected String getCriteriaAlias(String property) {
        return this.getCriteriaAlias(property, JoinType.LEFT_OUTER_JOIN);
    }

    protected String getCriteriaAlias(String property, JoinType joinType) {
        int index = property.lastIndexOf(46);
        if (index <= 0) {
            return property;
        }
        return this._getCriteriaAlias(property.substring(0, index), joinType) + property.substring(index);
    }

    protected ConditionWrapper getConditionWrapper(String property, Object value) {
        if (!this.subquery) {
            int sign = property.indexOf(46);
            this.subquery = Hibernates.getPropertyType(this.sessionFactory, this.model, sign > 0 ? property.substring(0, sign) : property).isCollectionType();
        }
        Type type = Hibernates.getPropertyType(this.sessionFactory, this.model, property);
        Class<?> meta = Hibernates.getPropertyTypeClass(this.sessionFactory, type);
        if (type.isEntityType() || type.isCollectionType()) {
            ClassMetadata metadata = Hibernates.getClassMetadata(this.sessionFactory, meta);
            Class primaryType = metadata.getIdentifierType().getReturnedClass();
            property = property + '.' + metadata.getIdentifierPropertyName();
            if (value instanceof Collection || value instanceof Object[]) {
                List<Object> values = value instanceof Collection ? (List<Object>)value : Arrays.asList((Object[])value);
                ArrayList<Object> arrayList = new ArrayList<Object>(values.size());
                for (Object e : values) {
                    if (meta.isAssignableFrom(e.getClass())) {
                        arrayList.add(Hibernates.getIdentifier(this.sessionFactory, e));
                        continue;
                    }
                    arrayList.add(Beans.toObject((Class)primaryType, e));
                }
                return new ConditionWrapper(property, arrayList);
            }
            if (value != null && meta.isAssignableFrom(value.getClass())) {
                return new ConditionWrapper(property, Hibernates.getIdentifier(this.sessionFactory, value));
            }
            return new ConditionWrapper(property, Beans.toObject((Class)primaryType, (Object)value));
        }
        if (value instanceof Collection || value instanceof Object[]) {
            List<Object> values = value instanceof Collection ? (List<Object>)value : Arrays.asList((Object[])value);
            ArrayList<Object> converts = new ArrayList<Object>(values.size());
            for (Object e : values) {
                converts.add(Beans.toObject(meta, e));
            }
            return new ConditionWrapper(property, converts);
        }
        return new ConditionWrapper(property, Beans.toObject(meta, (Object)value));
    }

    protected Criterion getEmptyCriterion(String property) {
        if (Hibernates.getPropertyType(this.sessionFactory, this.model, property).isCollectionType()) {
            return Restrictions.isEmpty((String)this.getCriteriaAlias(property));
        }
        return Restrictions.isNull((String)this.getCriteriaAlias(property));
    }

    protected Criterion getEmptyCriterion(Collection<String> properties) {
        int i = 0;
        Criterion[] criterions = new Criterion[properties.size()];
        for (String property : properties) {
            if (Hibernates.getPropertyType(this.sessionFactory, this.model, property).isCollectionType()) {
                criterions[i++] = Restrictions.isEmpty((String)this.getCriteriaAlias(property));
                continue;
            }
            criterions[i++] = Restrictions.isNull((String)this.getCriteriaAlias(property));
        }
        return criterions.length == 1 ? criterions[0] : Restrictions.and((Criterion[])criterions);
    }

    protected Criterion getNonemptyCriterion(String property) {
        if (Hibernates.getPropertyType(this.sessionFactory, this.model, property).isCollectionType()) {
            return Restrictions.isNotEmpty((String)this.getCriteriaAlias(property));
        }
        return Restrictions.isNotNull((String)this.getCriteriaAlias(property));
    }

    protected Criterion getNonemptyCriterion(Collection<String> properties) {
        int i = 0;
        Criterion[] criterions = new Criterion[properties.size()];
        for (String property : properties) {
            if (Hibernates.getPropertyType(this.sessionFactory, this.model, property).isCollectionType()) {
                criterions[i++] = Restrictions.isNotEmpty((String)this.getCriteriaAlias(property));
                continue;
            }
            criterions[i++] = Restrictions.isNotNull((String)this.getCriteriaAlias(property));
        }
        return criterions.length == 1 ? criterions[0] : Restrictions.and((Criterion[])criterions);
    }

    protected Criterion getEqualCriterion(String property, Object value) {
        ConditionWrapper condition = this.getConditionWrapper(property, value);
        return Restrictions.eq((String)this.getCriteriaAlias(condition.getProperty()), (Object)condition.getValue());
    }

    protected Criterion getNotEqualCriterion(String property, Object value) {
        ConditionWrapper condition = this.getConditionWrapper(property, value);
        return Restrictions.ne((String)this.getCriteriaAlias(condition.getProperty()), (Object)condition.getValue());
    }

    protected Criterion getGreaterCriterion(String property, Object value) {
        ConditionWrapper condition = this.getConditionWrapper(property, value);
        return Restrictions.gt((String)this.getCriteriaAlias(condition.getProperty()), (Object)condition.getValue());
    }

    protected Criterion getGreaterEqualCriterion(String property, Object value) {
        ConditionWrapper condition = this.getConditionWrapper(property, value);
        return Restrictions.ge((String)this.getCriteriaAlias(condition.getProperty()), (Object)condition.getValue());
    }

    protected Criterion getLessCriterion(String property, Object value) {
        ConditionWrapper condition = this.getConditionWrapper(property, value);
        return Restrictions.lt((String)this.getCriteriaAlias(condition.getProperty()), (Object)condition.getValue());
    }

    protected Criterion getLessEqualCriterion(String property, Object value) {
        ConditionWrapper condition = this.getConditionWrapper(property, value);
        return Restrictions.le((String)this.getCriteriaAlias(condition.getProperty()), (Object)condition.getValue());
    }

    protected Criterion getBetweenCriterion(String property, Object low, Object high) {
        ConditionWrapper condition = this.getConditionWrapper(property, Arrays.asList(low, high));
        List values = (List)condition.getValue();
        return Restrictions.between((String)this.getCriteriaAlias(condition.getProperty()), values.get(0), values.get(1));
    }

    protected Criterion getStartCriterion(String property, String value) {
        ConditionWrapper condition = this.getConditionWrapper(property, null);
        return Restrictions.ilike((String)this.getCriteriaAlias(condition.getProperty()), (String)value, (MatchMode)MatchMode.START);
    }

    protected Criterion getStartCriterion(String property, Collection<String> values) {
        int i = 0;
        ConditionWrapper condition = this.getConditionWrapper(property, null);
        String alias = this.getCriteriaAlias(condition.getProperty());
        Criterion[] criterions = new Criterion[values.size()];
        for (String value : values) {
            criterions[i++] = Restrictions.ilike((String)alias, (String)value, (MatchMode)MatchMode.START);
        }
        return values.size() == 1 ? criterions[0] : Restrictions.or((Criterion[])criterions);
    }

    protected Criterion getNstartCriterion(String property, String value) {
        return Restrictions.not((Criterion)this.getStartCriterion(property, value));
    }

    protected Criterion getNstartCriterion(String property, Collection<String> values) {
        return Restrictions.not((Criterion)this.getStartCriterion(property, values));
    }

    protected Criterion getEndCriterion(String property, String value) {
        ConditionWrapper condition = this.getConditionWrapper(property, null);
        return Restrictions.ilike((String)this.getCriteriaAlias(condition.getProperty()), (String)value, (MatchMode)MatchMode.END);
    }

    protected Criterion getEndCriterion(String property, Collection<String> values) {
        int i = 0;
        ConditionWrapper condition = this.getConditionWrapper(property, null);
        String alias = this.getCriteriaAlias(condition.getProperty());
        Criterion[] criterions = new Criterion[values.size()];
        for (String value : values) {
            criterions[i++] = Restrictions.ilike((String)alias, (String)value, (MatchMode)MatchMode.END);
        }
        return values.size() == 1 ? criterions[0] : Restrictions.or((Criterion[])criterions);
    }

    protected Criterion getNendCriterion(String property, String value) {
        return Restrictions.not((Criterion)this.getEndCriterion(property, value));
    }

    protected Criterion getNendCriterion(String property, Collection<String> values) {
        return Restrictions.not((Criterion)this.getEndCriterion(property, values));
    }

    protected Criterion getLikeCriterion(String property, String value) {
        ConditionWrapper condition = this.getConditionWrapper(property, null);
        return Restrictions.ilike((String)this.getCriteriaAlias(condition.getProperty()), (String)value, (MatchMode)MatchMode.ANYWHERE);
    }

    protected Criterion getLikeCriterion(String property, Collection<String> values) {
        int i = 0;
        ConditionWrapper condition = this.getConditionWrapper(property, null);
        String alias = this.getCriteriaAlias(condition.getProperty());
        Criterion[] criterions = new Criterion[values.size()];
        for (String value : values) {
            criterions[i++] = Restrictions.ilike((String)alias, (String)value, (MatchMode)MatchMode.ANYWHERE);
        }
        return values.size() == 1 ? criterions[0] : Restrictions.or((Criterion[])criterions);
    }

    protected Criterion getNlikeCriterion(String property, String value) {
        return Restrictions.not((Criterion)this.getLikeCriterion(property, value));
    }

    protected Criterion getNlikeCriterion(String property, Collection<String> values) {
        return Restrictions.not((Criterion)this.getLikeCriterion(property, values));
    }

    protected Criterion getInCriterion(String property, Collection<?> values) {
        ConditionWrapper condition = this.getConditionWrapper(property, values);
        return Restrictions.in((String)this.getCriteriaAlias(condition.getProperty()), (Object[])((List)condition.getValue()).toArray());
    }

    protected Criterion getOrCriterion(String property, Collection<?> values) {
        Criterion[] criterions = new Criterion[values.size()];
        ConditionWrapper condition = this.getConditionWrapper(property, values);
        String alias = this.getCriteriaAlias(condition.getProperty());
        List converts = (List)condition.getValue();
        for (int i = 0; i < converts.size(); ++i) {
            criterions[i] = Restrictions.eq((String)alias, converts.get(i));
        }
        return Restrictions.or((Criterion[])criterions);
    }

    protected Criterion getNotCriterion(String property, Collection<?> values) {
        return Restrictions.not((Criterion)this.getOrCriterion(property, values));
    }

    protected Criterion getPropertyEqualCriterion(String property, String other) {
        return Restrictions.eqProperty((String)this.getCriteriaAlias(property), (String)this.getCriteriaAlias(other));
    }

    protected Criterion getPropertyNotEqualCriterion(String property, String other) {
        return Restrictions.neProperty((String)this.getCriteriaAlias(property), (String)this.getCriteriaAlias(other));
    }

    protected Criterion getPropertyLessCriterion(String property, String other) {
        return Restrictions.ltProperty((String)this.getCriteriaAlias(property), (String)this.getCriteriaAlias(other));
    }

    protected Criterion getPropertyLessEqualCriterion(String property, String other) {
        return Restrictions.leProperty((String)this.getCriteriaAlias(property), (String)this.getCriteriaAlias(other));
    }

    protected Criterion getPropertyGreaterCriterion(String property, String other) {
        return Restrictions.gtProperty((String)this.getCriteriaAlias(property), (String)this.getCriteriaAlias(other));
    }

    protected Criterion getPropertyGreaterEqualCriterion(String property, String other) {
        return Restrictions.geProperty((String)this.getCriteriaAlias(property), (String)this.getCriteriaAlias(other));
    }

    protected Criterion getConditionCriterion(String property, Object value) {
        String key = property;
        String handle = "eq";
        int index = key.indexOf("__");
        if (index > 0) {
            handle = key.substring(index + "__".length());
            key = key.substring(0, index);
        }
        if (handle.equals("empty")) {
            return this.getEmptyCriterion(key);
        }
        if (handle.equals("nempty")) {
            return this.getNonemptyCriterion(key);
        }
        if (Beans.isEmpty((Object)value)) {
            return null;
        }
        if (handle.equals("start")) {
            if (value instanceof Collection) {
                return this.getStartCriterion(key, (Collection)value);
            }
            if (value instanceof String[]) {
                return this.getStartCriterion(key, Arrays.asList((String[])value));
            }
            return this.getStartCriterion(key, value.toString());
        }
        if (handle.equals("nstart")) {
            if (value instanceof Collection) {
                return this.getNstartCriterion(key, (Collection)value);
            }
            if (value instanceof String[]) {
                return this.getNstartCriterion(key, Arrays.asList((String[])value));
            }
            return this.getNstartCriterion(key, value.toString());
        }
        if (handle.equals("end")) {
            if (value instanceof Collection) {
                return this.getEndCriterion(key, (Collection)value);
            }
            if (value instanceof String[]) {
                return this.getEndCriterion(key, Arrays.asList((String[])value));
            }
            return this.getEndCriterion(key, value.toString());
        }
        if (handle.equals("nend")) {
            if (value instanceof Collection) {
                return this.getNendCriterion(key, (Collection)value);
            }
            if (value instanceof String[]) {
                return this.getNendCriterion(key, Arrays.asList((String[])value));
            }
            return this.getNendCriterion(key, value.toString());
        }
        if (handle.equals("like")) {
            if (value instanceof Collection) {
                return this.getLikeCriterion(key, (Collection)value);
            }
            if (value instanceof String[]) {
                return this.getLikeCriterion(key, Arrays.asList((String[])value));
            }
            return this.getLikeCriterion(key, value.toString());
        }
        if (handle.equals("nlike")) {
            if (value instanceof Collection) {
                return this.getNlikeCriterion(key, (Collection)value);
            }
            if (value instanceof String[]) {
                return this.getNlikeCriterion(key, Arrays.asList((String[])value));
            }
            return this.getNlikeCriterion(key, value.toString());
        }
        if (handle.equals("eq")) {
            return this.getEqualCriterion(key, value);
        }
        if (handle.equals("ne")) {
            return this.getNotEqualCriterion(key, value);
        }
        if (handle.equals("gt")) {
            return this.getGreaterCriterion(key, value);
        }
        if (handle.equals("ge")) {
            return this.getGreaterEqualCriterion(key, value);
        }
        if (handle.equals("lt")) {
            return this.getLessCriterion(key, value);
        }
        if (handle.equals("le")) {
            return this.getLessEqualCriterion(key, value);
        }
        if (handle.equals("in")) {
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                if (values.size() == 1) {
                    return this.getEqualCriterion(key, values.iterator().next());
                }
                return this.getInCriterion(key, values);
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                if (values.length == 1) {
                    return this.getEqualCriterion(key, values[0]);
                }
                return this.getInCriterion(key, Arrays.asList(values));
            }
            return this.getEqualCriterion(key, value);
        }
        if (handle.equals("or")) {
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                if (values.size() == 1) {
                    return this.getEqualCriterion(key, values.iterator().next());
                }
                return this.getOrCriterion(key, values);
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                if (values.length == 1) {
                    return this.getEqualCriterion(key, values[0]);
                }
                return this.getOrCriterion(key, Arrays.asList(values));
            }
            return this.getEqualCriterion(key, value);
        }
        if (handle.equals("not")) {
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                if (values.size() == 1) {
                    return this.getNotEqualCriterion(key, values.iterator().next());
                }
                return this.getNotCriterion(key, values);
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                if (values.length == 1) {
                    return this.getNotEqualCriterion(key, values[0]);
                }
                return this.getNotCriterion(key, Arrays.asList(values));
            }
            return this.getNotEqualCriterion(key, value);
        }
        if (handle.equals("peq")) {
            return this.getPropertyEqualCriterion(key, value.toString());
        }
        if (handle.equals("pne")) {
            return this.getPropertyNotEqualCriterion(key, value.toString());
        }
        if (handle.equals("plt")) {
            return this.getPropertyLessCriterion(key, value.toString());
        }
        if (handle.equals("ple")) {
            return this.getPropertyLessEqualCriterion(key, value.toString());
        }
        if (handle.equals("pgt")) {
            return this.getPropertyGreaterCriterion(key, value.toString());
        }
        if (handle.equals("pge")) {
            return this.getPropertyGreaterEqualCriterion(key, value.toString());
        }
        throw new RuntimeException("Not support query property:" + property);
    }

    protected Criterion getConditionCriterion(Conditions.Logic logic) {
        if (logic == null) {
            return null;
        }
        if (logic instanceof Conditions.Or) {
            Conditions.Logic[] logics = ((Conditions.Or)logic).getLogics();
            if (logics.length == 1) {
                return this.getConditionCriterion(logics[0]);
            }
            LinkedList<Criterion> criterions = new LinkedList<Criterion>();
            for (int i = 0; i < logics.length; ++i) {
                Criterion criterion = this.getConditionCriterion(logics[i]);
                if (criterion == null) continue;
                criterions.add(criterion);
            }
            return criterions.isEmpty() ? null : Restrictions.or((Criterion[])criterions.toArray(new Criterion[0]));
        }
        if (logic instanceof Conditions.And) {
            Conditions.Logic[] logics = ((Conditions.And)logic).getLogics();
            if (logics.length == 1) {
                return this.getConditionCriterion(logics[0]);
            }
            LinkedList<Criterion> criterions = new LinkedList<Criterion>();
            for (int i = 0; i < logics.length; ++i) {
                Criterion criterion = this.getConditionCriterion(logics[i]);
                if (criterion == null) continue;
                criterions.add(criterion);
            }
            return criterions.isEmpty() ? null : Restrictions.and((Criterion[])criterions.toArray(new Criterion[0]));
        }
        if (logic instanceof Conditions.Condition) {
            Conditions.Condition condition = (Conditions.Condition)logic;
            return this.getConditionCriterion(condition.getKey(), condition.getValue());
        }
        throw new RuntimeException("Not support query logic:" + logic);
    }

    protected void order(String property) {
        if (property != null && !property.isEmpty()) {
            String name;
            boolean desc = property.charAt(0) == '-';
            String string = name = desc || property.charAt(0) == '+' ? property.substring(1) : property;
            if (desc) {
                this.desc(name);
            } else {
                this.asc(name);
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.list().iterator();
    }

    @Override
    public Class<T> getModel() {
        return this.model;
    }

    @Override
    public Query<T> empty(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (properties.length == 1) {
                this.criteria.add(this.getEmptyCriterion(properties[0]));
            } else {
                this.criteria.add(this.getEmptyCriterion(Arrays.asList(properties)));
            }
        }
        return this;
    }

    @Override
    public Query<T> nonempty(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (properties.length == 1) {
                this.criteria.add(this.getNonemptyCriterion(properties[0]));
            } else {
                this.criteria.add(this.getNonemptyCriterion(Arrays.asList(properties)));
            }
        }
        return this;
    }

    @Override
    public Query<T> eq(String property, Object value) {
        if (property != null && value != null) {
            this.criteria.add(this.getEqualCriterion(property, value));
        }
        return this;
    }

    @Override
    public Query<T> ne(String property, Object value) {
        if (property != null && value != null) {
            this.criteria.add(this.getNotEqualCriterion(property, value));
        }
        return this;
    }

    @Override
    public Query<T> gt(String property, Object value) {
        if (property != null && value != null) {
            this.criteria.add(this.getGreaterCriterion(property, value));
        }
        return this;
    }

    @Override
    public Query<T> ge(String property, Object value) {
        if (property != null && value != null) {
            this.criteria.add(this.getGreaterEqualCriterion(property, value));
        }
        return this;
    }

    @Override
    public Query<T> lt(String property, Object value) {
        if (property != null && value != null) {
            this.criteria.add(this.getLessCriterion(property, value));
        }
        return this;
    }

    @Override
    public Query<T> le(String property, Object value) {
        if (property != null && value != null) {
            this.criteria.add(this.getLessEqualCriterion(property, value));
        }
        return this;
    }

    @Override
    public Query<T> between(String property, Object low, Object high) {
        if (property != null && low != null && high != null) {
            this.criteria.add(this.getBetweenCriterion(property, low, high));
        }
        return this;
    }

    @Override
    public Query<T> start(String property, String ... values) {
        if (property != null && values != null && values.length > 0) {
            if (values.length == 1) {
                this.criteria.add(this.getStartCriterion(property, values[0]));
            } else {
                this.criteria.add(this.getStartCriterion(property, Arrays.asList(values)));
            }
        }
        return this;
    }

    @Override
    public Query<T> nstart(String property, String ... values) {
        if (property != null && values != null && values.length > 0) {
            if (values.length == 1) {
                this.criteria.add(this.getNstartCriterion(property, values[0]));
            } else {
                this.criteria.add(this.getNstartCriterion(property, Arrays.asList(values)));
            }
        }
        return this;
    }

    @Override
    public Query<T> end(String property, String ... values) {
        if (property != null && values != null && values.length > 0) {
            if (values.length == 1) {
                this.criteria.add(this.getEndCriterion(property, values[0]));
            } else {
                this.criteria.add(this.getEndCriterion(property, Arrays.asList(values)));
            }
        }
        return this;
    }

    @Override
    public Query<T> nend(String property, String ... values) {
        if (property != null && values != null && values.length > 0) {
            if (values.length == 1) {
                this.criteria.add(this.getNendCriterion(property, values[0]));
            } else {
                this.criteria.add(this.getNendCriterion(property, Arrays.asList(values)));
            }
        }
        return this;
    }

    @Override
    public Query<T> like(String property, String ... values) {
        if (property != null && values != null && values.length > 0) {
            if (values.length == 1) {
                this.criteria.add(this.getLikeCriterion(property, values[0]));
            } else {
                this.criteria.add(this.getLikeCriterion(property, Arrays.asList(values)));
            }
        }
        return this;
    }

    @Override
    public Query<T> nlike(String property, String ... values) {
        if (property != null && values != null && values.length > 0) {
            if (values.length == 1) {
                this.criteria.add(this.getNlikeCriterion(property, values[0]));
            } else {
                this.criteria.add(this.getNlikeCriterion(property, Arrays.asList(values)));
            }
        }
        return this;
    }

    @Override
    public Query<T> in(String property, Object[] values) {
        if (property != null && values != null && values.length > 0) {
            if (values.length == 1) {
                this.criteria.add(this.getEqualCriterion(property, values[0]));
            } else {
                this.criteria.add(this.getInCriterion(property, Arrays.asList(values)));
            }
        }
        return this;
    }

    @Override
    public Query<T> or(String property, Object[] values) {
        if (property != null && values != null && values.length > 0) {
            if (values.length == 1) {
                this.criteria.add(this.getEqualCriterion(property, values[0]));
            } else {
                this.criteria.add(this.getOrCriterion(property, Arrays.asList(values)));
            }
        }
        return this;
    }

    @Override
    public Query<T> not(String property, Object[] values) {
        if (property != null && values != null && values.length > 0) {
            if (values.length == 1) {
                this.criteria.add(this.getNotEqualCriterion(property, values[0]));
            } else {
                this.criteria.add(this.getNotCriterion(property, Arrays.asList(values)));
            }
        }
        return this;
    }

    @Override
    public Query<T> custom(String property, Object value) {
        if (Strings.isEmpty((String)property)) {
            return this;
        }
        if (property.equals("__min")) {
            if (!Beans.isEmpty((Object)value)) {
                this.min((String[])Beans.toArray(String.class, (Object)value));
            }
        } else if (property.equals("__max")) {
            if (!Beans.isEmpty((Object)value)) {
                this.max((String[])Beans.toArray(String.class, (Object)value));
            }
        } else if (property.equals("__sum")) {
            if (!Beans.isEmpty((Object)value)) {
                this.sum((String[])Beans.toArray(String.class, (Object)value));
            }
        } else if (property.equals("__avg")) {
            if (!Beans.isEmpty((Object)value)) {
                this.avg((String[])Beans.toArray(String.class, (Object)value));
            }
        } else if (property.equals("__group")) {
            if (!Beans.isEmpty((Object)value)) {
                this.group((String[])Beans.toArray(String.class, (Object)value));
            }
        } else if (property.equals("__number")) {
            if (!Beans.isEmpty((Object)value)) {
                this.number((String[])Beans.toArray(String.class, (Object)value));
            }
        } else if (property.equals("__property")) {
            if (!Beans.isEmpty((Object)value)) {
                this.property((String[])Beans.toArray(String.class, (Object)value));
            }
        } else if (property.equals("__page")) {
            if (!Beans.isEmpty((Object)value)) {
                this.page = Integer.parseInt(value.toString());
            }
        } else if (property.equals("__size")) {
            if (!Beans.isEmpty((Object)value)) {
                this.size = Integer.parseInt(value.toString());
            }
        } else if (property.equals("__order")) {
            if (value instanceof Collection) {
                for (String order : (Collection)value) {
                    this.order(order);
                }
            } else if (value instanceof String[]) {
                for (String order : (String[])value) {
                    this.order(order);
                }
            } else if (!Beans.isEmpty((Object)value)) {
                this.order(value.toString());
            }
        } else if (property.equals("__condition")) {
            if (!Beans.isEmpty((Object)value)) {
                Conditions.Logic logic = value instanceof Conditions.Logic ? (Conditions.Logic)value : Conditions.parse((String)value.toString());
                this.condition(logic);
            }
        } else {
            this.condition(property, value);
        }
        return this;
    }

    @Override
    public Query<T> custom(Map<String, Object> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                this.custom(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public Query<T> condition(Conditions.Logic logic) {
        Criterion criterion;
        if (logic != null && (criterion = this.getConditionCriterion(logic)) != null) {
            this.criteria.add(criterion);
        }
        return this;
    }

    @Override
    public Query<T> condition(String property, Object value) {
        Criterion criterion;
        if (property != null && (criterion = this.getConditionCriterion(property, value)) != null) {
            this.criteria.add(criterion);
        }
        return this;
    }

    @Override
    public Query<T> condition(Map<String, Object> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                this.condition(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public Query<T> eqProperty(String property, String other) {
        if (property != null && other != null) {
            this.criteria.add(this.getPropertyEqualCriterion(property, other));
        }
        return this;
    }

    @Override
    public Query<T> neProperty(String property, String other) {
        if (property != null && other != null) {
            this.criteria.add(this.getPropertyNotEqualCriterion(property, other));
        }
        return this;
    }

    @Override
    public Query<T> ltProperty(String property, String other) {
        if (property != null && other != null) {
            this.criteria.add(this.getPropertyLessCriterion(property, other));
        }
        return this;
    }

    @Override
    public Query<T> leProperty(String property, String other) {
        if (property != null && other != null) {
            this.criteria.add(this.getPropertyLessEqualCriterion(property, other));
        }
        return this;
    }

    @Override
    public Query<T> gtProperty(String property, String other) {
        if (property != null && other != null) {
            this.criteria.add(this.getPropertyGreaterCriterion(property, other));
        }
        return this;
    }

    @Override
    public Query<T> geProperty(String property, String other) {
        if (property != null && other != null) {
            this.criteria.add(this.getPropertyGreaterEqualCriterion(property, other));
        }
        return this;
    }

    @Override
    public Query<T> asc(String ... properties) {
        if (properties != null && properties.length > 0) {
            for (String property : properties) {
                this.orders.add("+" + property);
            }
        }
        return this;
    }

    @Override
    public Query<T> desc(String ... properties) {
        if (properties != null && properties.length > 0) {
            for (String property : properties) {
                this.orders.add("-" + property);
            }
        }
        return this;
    }

    @Override
    public Query<T> paging(int page, int size) {
        if (page < 1) {
            throw new IllegalArgumentException("Illegal page:" + page);
        }
        if (size < 1) {
            throw new IllegalArgumentException("Illegal size:" + size);
        }
        this.page = page;
        this.size = size;
        return this;
    }

    @Override
    public Query<T> min(String ... properties) {
        if (properties != null && properties.length > 0) {
            for (String property : properties) {
                this.projections.add((Projection)Projections.min((String)this.getCriteriaAlias(property)));
            }
        }
        return this;
    }

    @Override
    public Query<T> max(String ... properties) {
        if (properties != null && properties.length > 0) {
            for (String property : properties) {
                this.projections.add((Projection)Projections.max((String)this.getCriteriaAlias(property)));
            }
        }
        return this;
    }

    @Override
    public Query<T> avg(String ... properties) {
        if (properties != null && properties.length > 0) {
            for (String property : properties) {
                this.projections.add((Projection)Projections.avg((String)this.getCriteriaAlias(property)));
            }
        }
        return this;
    }

    @Override
    public Query<T> sum(String ... properties) {
        if (properties != null && properties.length > 0) {
            for (String property : properties) {
                this.projections.add((Projection)Projections.sum((String)this.getCriteriaAlias(property)));
            }
        }
        return this;
    }

    @Override
    public Query<T> number(String ... properties) {
        if (properties != null && properties.length > 0) {
            for (String property : properties) {
                this.projections.add((Projection)Projections.count((String)this.getCriteriaAlias(property)));
            }
        }
        return this;
    }

    @Override
    public Query<T> group(String ... properties) {
        if (properties != null && properties.length > 0) {
            for (String property : properties) {
                this.projections.add((Projection)Projections.groupProperty((String)this.getCriteriaAlias(property)));
            }
        }
        return this;
    }

    @Override
    public Query<T> property(String ... properties) {
        if (properties != null && properties.length > 0) {
            for (String property : properties) {
                this.projections.add((Projection)Projections.property((String)this.getCriteriaAlias(property)));
            }
        }
        return this;
    }

    @Override
    public int count() {
        if (this.count == null) {
            if (this.loaded) {
                this.count = this.objects.size();
            } else {
                Session session = this.sessionFactory.openSession();
                try {
                    this.count = (int)((Long)this.getExecutableCriteria(session).setProjection(Projections.rowCount()).uniqueResult()).longValue();
                }
                finally {
                    session.close();
                }
            }
        }
        return this.count;
    }

    @Override
    public T single() {
        if (!this.loaded) {
            this.loaded = true;
            Session session = this.sessionFactory.openSession();
            try {
                this.object = this.getExecutableCriteria(session).uniqueResult();
            }
            finally {
                session.close();
            }
        }
        return this.object;
    }

    @Override
    public List<T> list() {
        if (!this.loaded) {
            this.loaded = true;
            Session session = this.sessionFactory.openSession();
            try {
                this.objects = this.getExecutableCriteria(session).list();
            }
            finally {
                session.close();
            }
        }
        return this.objects;
    }

    @Override
    public List<?> stats() {
        if (!this.loaded) {
            this.loaded = true;
            if (this.projections.getLength() == 0) {
                this.stats = new ArrayList(0);
            } else {
                Session session = this.sessionFactory.openSession();
                try {
                    this.stats = this.getExecutableCriteria(session).setProjection((Projection)this.projections).list();
                    Iterator<?> iterator = this.stats.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != null) continue;
                        iterator.remove();
                    }
                }
                finally {
                    session.close();
                }
            }
        }
        return this.stats;
    }

    class ConditionWrapper {
        private String property;
        private Object value;

        public ConditionWrapper(String property, Object value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

