/*
 * Decompiled with CFR 0.152.
 */
package ars.database.repository;

import ars.database.model.Model;
import ars.database.model.TreeModel;
import ars.database.repository.Repositories;
import ars.database.repository.Repository;
import ars.util.Beans;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public abstract class AbstractRepository<T>
implements Repository<T> {
    private Class<T> model;

    public AbstractRepository() {
        Class[] genericTypes = Beans.getGenericTypes(this.getClass());
        if (genericTypes.length == 0) {
            throw new RuntimeException("Generic type not found:" + this.getClass().getName());
        }
        this.model = genericTypes[0];
    }

    protected abstract void modify(T var1);

    protected abstract Serializable insert(T var1);

    protected abstract void remove(T var1);

    @Override
    public Class<T> getModel() {
        return this.model;
    }

    @Override
    public String getPrimary() {
        return "id";
    }

    @Override
    public T get(Object id) {
        return id == null ? null : (T)this.query().eq(this.getPrimary(), id).single();
    }

    @Override
    public Serializable save(T object) {
        if (object instanceof Model) {
            Model entity = (Model)object;
            entity.setDateJoined(new Date());
            if (entity instanceof TreeModel) {
                TreeModel tree = (TreeModel)object;
                TreeModel parent = (TreeModel)tree.getParent();
                if (parent != null) {
                    tree.setLevel(parent.getLevel() + 1);
                    if (parent.getLeaf() == Boolean.TRUE) {
                        parent.setLeaf(false);
                        this.modify(parent);
                    }
                }
                tree.setKey(UUID.randomUUID().toString());
            }
        }
        Serializable id = this.insert(object);
        if (object instanceof Model) {
            boolean changed = false;
            Model entity = (Model)object;
            if (entity.getOrder() == null) {
                entity.setOrder(((Number)id).doubleValue());
                changed = true;
            }
            if (entity instanceof TreeModel) {
                TreeModel tree = (TreeModel)object;
                tree.setKey(Repositories.buildTreeKey(tree, ((Number)id).intValue()));
                changed = true;
            }
            if (changed) {
                this.modify(object);
            }
        }
        return id;
    }

    @Override
    public void update(T object) {
        if (object instanceof Model) {
            Model entity = (Model)object;
            entity.setDateUpdate(new Date());
            if (entity instanceof TreeModel) {
                TreeModel tree = (TreeModel)object;
                String key = tree.getKey();
                int level = tree.getLevel();
                TreeModel parent = (TreeModel)tree.getParent();
                String pkey = Repositories.getParentKey(key);
                if (!Beans.isEqual((Object)pkey, (Object)(parent == null ? null : parent.getKey()))) {
                    TreeModel sparent;
                    if (parent == null) {
                        tree.setLevel(1);
                    } else {
                        tree.setLevel(parent.getLevel() + 1);
                        if (parent.getLeaf() == Boolean.TRUE) {
                            parent.setLeaf(false);
                            this.modify(parent);
                        }
                    }
                    if (pkey != null && (sparent = (TreeModel)this.query().eq("key", pkey).single()) != null) {
                        Boolean leaf = this.query().ne("key", pkey).eq("level", sparent.getLevel() + 1).start("key", pkey).count() == 1;
                        if (sparent.getLeaf() != leaf) {
                            sparent.setLeaf(leaf);
                            this.modify(sparent);
                        }
                    }
                    Repositories.refreshTreeKey(tree);
                    List relates = this.query().ne("key", key).start("key", key).list();
                    for (int i = 0; i < relates.size(); ++i) {
                        TreeModel relate = (TreeModel)relates.get(i);
                        StringBuilder keyBuilder = new StringBuilder(tree.getKey()).append(relate.getKey().substring(Repositories.getParentKey(relate.getKey()).length()));
                        relate.setKey(keyBuilder.toString());
                        relate.setLevel(relate.getLevel() - level + tree.getLevel());
                        this.modify(relate);
                    }
                }
            }
        }
        this.modify(object);
    }

    @Override
    public void delete(T object) {
        Boolean leaf;
        TreeModel parent;
        if (object instanceof TreeModel && (parent = (TreeModel)((TreeModel)object).getParent()) != null && (leaf = Boolean.valueOf(this.query().eq("parent", parent).count() == 1)) != parent.getLeaf()) {
            parent.setLeaf(leaf);
            this.modify(parent);
        }
        this.remove(object);
    }
}

