/*
 * Decompiled with CFR 0.152.
 */
package ars.database.repository;

import ars.util.Conditions;
import java.util.List;
import java.util.Map;

public interface Query<T>
extends Iterable<T> {
    public static final String DELIMITER = "__";
    public static final String EQ = "eq";
    public static final String GE = "ge";
    public static final String GT = "gt";
    public static final String LE = "le";
    public static final String LT = "lt";
    public static final String NE = "ne";
    public static final String IN = "in";
    public static final String OR = "or";
    public static final String NOT = "not";
    public static final String PEQ = "peq";
    public static final String PNE = "pne";
    public static final String PLT = "plt";
    public static final String PLE = "ple";
    public static final String PGT = "pgt";
    public static final String PGE = "pge";
    public static final String EMPTY = "empty";
    public static final String NOT_EMPTY = "nempty";
    public static final String START = "start";
    public static final String NOT_START = "nstart";
    public static final String END = "end";
    public static final String NOT_END = "nend";
    public static final String LIKE = "like";
    public static final String NOT_LIKE = "nlike";
    public static final String MIN = "__min";
    public static final String MAX = "__max";
    public static final String AVG = "__avg";
    public static final String SUM = "__sum";
    public static final String GROUP = "__group";
    public static final String NUMBER = "__number";
    public static final String PROPERTY = "__property";
    public static final String PAGE = "__page";
    public static final String SIZE = "__size";
    public static final String ORDER = "__order";
    public static final String CONDITION = "__condition";

    public Class<T> getModel();

    public Query<T> empty(String ... var1);

    public Query<T> nonempty(String ... var1);

    public Query<T> eq(String var1, Object var2);

    public Query<T> ne(String var1, Object var2);

    public Query<T> gt(String var1, Object var2);

    public Query<T> ge(String var1, Object var2);

    public Query<T> lt(String var1, Object var2);

    public Query<T> le(String var1, Object var2);

    public Query<T> between(String var1, Object var2, Object var3);

    public Query<T> start(String var1, String ... var2);

    public Query<T> nstart(String var1, String ... var2);

    public Query<T> end(String var1, String ... var2);

    public Query<T> nend(String var1, String ... var2);

    public Query<T> like(String var1, String ... var2);

    public Query<T> nlike(String var1, String ... var2);

    public Query<T> in(String var1, Object[] var2);

    public Query<T> or(String var1, Object[] var2);

    public Query<T> not(String var1, Object[] var2);

    public Query<T> custom(String var1, Object var2);

    public Query<T> custom(Map<String, Object> var1);

    public Query<T> condition(Conditions.Logic var1);

    public Query<T> condition(String var1, Object var2);

    public Query<T> condition(Map<String, Object> var1);

    public Query<T> eqProperty(String var1, String var2);

    public Query<T> neProperty(String var1, String var2);

    public Query<T> ltProperty(String var1, String var2);

    public Query<T> leProperty(String var1, String var2);

    public Query<T> gtProperty(String var1, String var2);

    public Query<T> geProperty(String var1, String var2);

    public Query<T> asc(String ... var1);

    public Query<T> desc(String ... var1);

    public Query<T> paging(int var1, int var2);

    public Query<T> min(String ... var1);

    public Query<T> max(String ... var1);

    public Query<T> avg(String ... var1);

    public Query<T> sum(String ... var1);

    public Query<T> number(String ... var1);

    public Query<T> group(String ... var1);

    public Query<T> property(String ... var1);

    public int count();

    public T single();

    public List<T> list();

    public List<?> stats();
}

