/*
 * Decompiled with CFR 0.152.
 */
package ars.database.repository;

import ars.database.model.TreeModel;
import ars.database.repository.EmptyQuery;
import ars.database.repository.Query;
import ars.database.repository.Repository;
import ars.database.repository.RepositoryFactory;
import ars.util.AbstractTree;
import ars.util.Beans;
import ars.util.Formable;
import ars.util.Randoms;
import ars.util.SimpleTree;
import ars.util.Strings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Repositories {
    public static final char TREE_KEY_SEPARATOR = 'x';
    public static final String DEFAULT_PRIMARY_NAME = "id";
    private static RepositoryFactory repositoryFactory;

    private Repositories() {
    }

    public static RepositoryFactory getRepositoryFactory() {
        if (repositoryFactory == null) {
            throw new RuntimeException("Repository factory has not been initialize");
        }
        return repositoryFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setRepositoryFactory(RepositoryFactory repositoryFactory) {
        if (repositoryFactory == null) {
            throw new IllegalArgumentException("Illegal repositoryFactory:" + repositoryFactory);
        }
        if (Repositories.repositoryFactory != null) return;
        Class<Repositories> clazz = Repositories.class;
        synchronized (Repositories.class) {
            if (Repositories.repositoryFactory != null) return;
            Repositories.repositoryFactory = repositoryFactory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static List<Class<?>> getModels() {
        ArrayList models = new ArrayList(Repositories.getRepositoryFactory().getRepositories().keySet());
        Collections.sort(models, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return models;
    }

    public static <M> Repository<M> getRepository(Class<M> model) {
        return Repositories.getRepositoryFactory().getRepository(model);
    }

    public static String getParentKey(String key) {
        int count = 0;
        int index1 = -1;
        int index2 = -1;
        for (int i = key.length() - 1; i > -1; --i) {
            if (key.charAt(i) != 'x') continue;
            index1 = index2;
            index2 = i;
            if (++count > 2) break;
        }
        return count < 3 ? null : key.substring(0, index1 + 1);
    }

    public static String[] getParentKeys(String key) {
        if (key == null || key.isEmpty()) {
            return Strings.EMPTY_ARRAY;
        }
        int offset = 0;
        LinkedList<String> keys = new LinkedList<String>();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (i <= 0 || c != 'x') continue;
            keys.add(key.substring(offset, i + 1));
            offset = i;
        }
        return keys.subList(0, keys.size() - 1).toArray(Strings.EMPTY_ARRAY);
    }

    public static <M extends TreeModel> String buildTreeKey(M tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Illegal tree:" + tree);
        }
        return Repositories.buildTreeKey(tree, tree.getId());
    }

    public static <M extends TreeModel> String buildTreeKey(M tree, int sequence) {
        if (tree == null) {
            throw new IllegalArgumentException("Illegal tree:" + tree);
        }
        if (sequence < 0) {
            throw new IllegalArgumentException("Illegal sequence:" + sequence);
        }
        TreeModel parent = (TreeModel)tree.getParent();
        return "" + (parent == null ? Character.valueOf('x') : parent.getKey()) + sequence + 'x';
    }

    public static <M extends TreeModel> void refreshTreeKey(M tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Illegal tree:" + tree);
        }
        String key = tree.getKey();
        if (key == null) {
            tree.setKey(Repositories.buildTreeKey(tree));
        } else {
            TreeModel parent = (TreeModel)tree.getParent();
            String pkey = Repositories.getParentKey(key);
            if (parent == null && pkey != null) {
                tree.setKey(key.substring(pkey.length() - 1));
            } else if (pkey == null && parent != null) {
                tree.setKey(parent.getKey() + key.substring(1));
            } else if (parent != null && pkey != null && !Beans.isEqual((Object)parent.getKey(), (Object)pkey)) {
                tree.setKey(parent.getKey() + key.substring(pkey.length()));
            }
        }
    }

    public static <M extends TreeModel> List<M> mergeTrees(M[] trees) {
        if (trees == null) {
            throw new IllegalArgumentException("Illegal trees:" + trees);
        }
        return trees.length == 0 ? new ArrayList(0) : Repositories.mergeTrees(Arrays.asList(trees));
    }

    public static <M extends TreeModel> List<M> mergeTrees(Collection<M> trees) {
        if (trees == null) {
            throw new IllegalArgumentException("Illegal trees:" + trees);
        }
        if (trees.isEmpty()) {
            return new ArrayList(0);
        }
        LinkedHashMap<String, TreeModel> temp = new LinkedHashMap<String, TreeModel>(trees.size());
        HashMap groups = new HashMap();
        for (TreeModel tree : trees) {
            String parentKey;
            String key = tree.getKey();
            if (temp.containsKey(key)) continue;
            temp.put(key, tree);
            if (!groups.containsKey(key)) {
                groups.put(key, new LinkedList());
            }
            if ((parentKey = Repositories.getParentKey(key)) == null) continue;
            LinkedList<TreeModel> group = (LinkedList<TreeModel>)groups.get(parentKey);
            if (group == null) {
                group = new LinkedList<TreeModel>();
                groups.put(parentKey, group);
            }
            group.add(tree);
        }
        LinkedList<TreeModel> roots = new LinkedList<TreeModel>();
        for (Map.Entry entry : temp.entrySet()) {
            TreeModel tree = (TreeModel)entry.getValue();
            tree.setChildren((List)groups.get(entry.getKey()));
            String parentKey = Repositories.getParentKey(tree.getKey());
            if (parentKey != null && temp.containsKey(parentKey)) continue;
            roots.add(tree);
        }
        return roots;
    }

    public static String getPrimary(Class<?> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        return Repositories.getRepository(model).getPrimary();
    }

    public static <M> M get(Class<M> model, Object id) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        return id == null ? null : (M)Repositories.getRepository(model).get(id);
    }

    public static <M> M extract(Class<M> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        Repository<M> repository = Repositories.getRepository(model);
        int count = repository.query().count();
        if (count == 0) {
            return null;
        }
        int size = 100;
        int page = Randoms.randomInteger((int)1, (int)((int)Math.ceil((double)count / (double)size) + 1));
        List<M> objects = repository.query().paging(page, size).list();
        return objects.get(Randoms.randomInteger((int)0, (int)objects.size()));
    }

    public static Serializable save(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Illegal object:" + object);
        }
        return Repositories.getRepository(object.getClass()).save(object);
    }

    public static void update(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Illegal object:" + object);
        }
        Repositories.getRepository(object.getClass()).update(object);
    }

    public static void delete(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Illegal object:" + object);
        }
        Repositories.getRepository(object.getClass()).delete(object);
    }

    public static <M extends TreeModel> void saveTree(M object) {
        if (object == null) {
            throw new IllegalArgumentException("Illegal object:" + object);
        }
        Repositories.saveTree(Repositories.getRepository(object.getClass()), object);
    }

    public static <M extends TreeModel> void saveTree(Repository<M> repository, M object) {
        if (repository == null) {
            throw new IllegalArgumentException("Illegal repository:" + repository);
        }
        if (object == null) {
            throw new IllegalArgumentException("Illegal object:" + object);
        }
        ArrayList children = new ArrayList(object.getChildren());
        object.getChildren().clear();
        Serializable id = repository.save(object);
        object.setId((Integer)id);
        for (int i = 0; i < children.size(); ++i) {
            TreeModel child = (TreeModel)children.get(i);
            child.setParent(object);
            Repositories.saveTree(repository, child);
        }
    }

    public static SimpleTree getSimpleTree(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Illegal object:" + object);
        }
        String id = object.getClass().getSimpleName() + '_' + object.hashCode();
        Map values = object instanceof Formable ? ((Formable)object).format() : Beans.getValues((Object)object, (String[])new String[0]);
        return new SimpleTree(id, object.toString(), values);
    }

    public static List<SimpleTree> getSimpleTrees(Collection<?> objects) {
        return Repositories.getSimpleTrees(objects, null);
    }

    public static <M> List<SimpleTree> getSimpleTrees(Collection<M> objects, Map<M, SimpleTree> mappings) {
        if (objects == null) {
            throw new IllegalArgumentException("Illegal objects:" + objects);
        }
        if (objects.isEmpty()) {
            return new ArrayList<SimpleTree>(0);
        }
        ArrayList<SimpleTree> simples = new ArrayList<SimpleTree>(objects.size());
        for (M object : objects) {
            List children;
            SimpleTree tree = Repositories.getSimpleTree(object);
            if (mappings != null) {
                mappings.put(object, tree);
            }
            if (object instanceof TreeModel && !(children = ((TreeModel)object).getChildren()).isEmpty()) {
                List<SimpleTree> schildren = Repositories.getSimpleTrees(children, mappings);
                tree.setChildren(schildren);
                for (int i = 0; i < schildren.size(); ++i) {
                    schildren.get(i).setParent((AbstractTree)tree);
                }
            }
            simples.add(tree);
        }
        return simples;
    }

    public static <M> Query<M> query(Class<M> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        return Repositories.getRepository(model).query();
    }

    public static <M> Query<M> emptyQuery() {
        return EmptyQuery.instance();
    }

    public static <M> M random(final Class<M> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        final Set<Class<?>> models = Repositories.getRepositoryFactory().getRepositories().keySet();
        return (M)Randoms.random(model).register(new Randoms.ExcludeStrategy(){

            public boolean exclude(Class<?> type, Field field) {
                return Modifier.isAbstract(type.getModifiers()) || field != null && models.contains(type) && (field.getName().equals(Repositories.getPrimary(type)) || TreeModel.class.isAssignableFrom(type) && (field.getName().equals("key") || field.getName().equals("level") || field.getName().equals("leaf") || field.getName().equals("parent")));
            }
        }).register(new Randoms.RandomGeneratorFactory(){

            public <T> Randoms.RandomGenerator<T> getRandomGenerator(final Class<T> type, Field field) {
                if (type == model || !models.contains(type)) {
                    return null;
                }
                return new Randoms.RandomGenerator<T>(){

                    public T generate() {
                        return Repositories.extract(type);
                    }
                };
            }
        }).build();
    }
}

