/*
 * Decompiled with CFR 0.152.
 */
package ars.database.service;

import ars.database.model.Model;
import ars.database.model.TreeModel;
import ars.database.repository.Query;
import ars.database.repository.Repositories;
import ars.database.repository.Repository;
import ars.database.service.Service;
import ars.database.service.event.DeleteEvent;
import ars.database.service.event.InitEvent;
import ars.database.service.event.QueryEvent;
import ars.database.service.event.SaveEvent;
import ars.database.service.event.ServiceEvent;
import ars.database.service.event.ServiceListener;
import ars.database.service.event.UpdateEvent;
import ars.invoke.request.ParameterInvalidException;
import ars.invoke.request.Requester;
import ars.util.Beans;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractService<T>
implements Service<T> {
    private Class<T> model;
    private Repository<T> repository;
    private List<ServiceListener<?>> initListeners = new LinkedList();
    private List<ServiceListener<?>> saveListeners = new LinkedList();
    private List<ServiceListener<?>> queryListeners = new LinkedList();
    private List<ServiceListener<?>> updateListeners = new LinkedList();
    private List<ServiceListener<?>> deleteListeners = new LinkedList();

    public AbstractService() {
        Class[] genericTypes = Beans.getGenericTypes(this.getClass());
        if (genericTypes.length == 0) {
            throw new RuntimeException("Generic type not found:" + this.getClass().getName());
        }
        this.model = genericTypes[0];
    }

    protected void onInitEvent(Requester requester, T entity) {
        if (!this.initListeners.isEmpty()) {
            InitEvent event = new InitEvent(requester, this, entity);
            for (ServiceListener<?> listener : this.initListeners) {
                listener.onServiceEvent(event);
            }
        }
    }

    protected void onSaveEvent(Requester requester, Serializable id, T entity) {
        if (!this.saveListeners.isEmpty()) {
            SaveEvent event = new SaveEvent(requester, this, id, entity);
            for (ServiceListener<?> listener : this.saveListeners) {
                listener.onServiceEvent(event);
            }
        }
    }

    protected void onDeleteEvent(Requester requester, T entity) {
        if (!this.deleteListeners.isEmpty()) {
            DeleteEvent event = new DeleteEvent(requester, this, entity);
            for (ServiceListener<?> listener : this.deleteListeners) {
                listener.onServiceEvent(event);
            }
        }
    }

    protected void onUpdateEvent(Requester requester, Object entity) {
        if (!this.updateListeners.isEmpty()) {
            UpdateEvent event = new UpdateEvent(requester, this, entity);
            for (ServiceListener<?> listener : this.updateListeners) {
                listener.onServiceEvent(event);
            }
        }
    }

    protected void onQueryEvent(Requester requester, Query<T> query) {
        if (!this.queryListeners.isEmpty()) {
            QueryEvent event = new QueryEvent(requester, this, query);
            for (ServiceListener<?> listener : this.queryListeners) {
                listener.onServiceEvent(event);
            }
        }
    }

    @Override
    public Class<T> getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository<T> getRepository() {
        if (this.repository == null) {
            AbstractService abstractService = this;
            synchronized (abstractService) {
                if (this.repository == null) {
                    this.repository = Repositories.getRepository(this.model);
                }
            }
        }
        return this.repository;
    }

    @Override
    public <E extends ServiceEvent> void setListeners(Class<E> type, ServiceListener<E> ... listeners) {
        if (listeners.length > 0) {
            List<ServiceListener<E>> list = Arrays.asList(listeners);
            if (type == InitEvent.class) {
                this.initListeners.clear();
                this.initListeners.addAll(list);
            } else if (type == SaveEvent.class) {
                this.saveListeners.clear();
                this.saveListeners.addAll(list);
            } else if (type == QueryEvent.class) {
                this.queryListeners.clear();
                this.queryListeners.addAll(list);
            } else if (type == UpdateEvent.class) {
                this.updateListeners.clear();
                this.updateListeners.addAll(list);
            } else if (type == DeleteEvent.class) {
                this.deleteListeners.clear();
                this.deleteListeners.addAll(list);
            } else {
                this.initListeners.clear();
                this.saveListeners.clear();
                this.queryListeners.clear();
                this.updateListeners.clear();
                this.deleteListeners.clear();
                this.initListeners.addAll(list);
                this.saveListeners.addAll(list);
                this.queryListeners.addAll(list);
                this.updateListeners.addAll(list);
                this.deleteListeners.addAll(list);
            }
        }
    }

    @Override
    public <E extends ServiceEvent> void addListeners(Class<E> type, ServiceListener<E> ... listeners) {
        if (listeners.length > 0) {
            List<ServiceListener<E>> list = Arrays.asList(listeners);
            if (type == InitEvent.class) {
                this.initListeners.addAll(list);
            } else if (type == SaveEvent.class) {
                this.saveListeners.addAll(list);
            } else if (type == QueryEvent.class) {
                this.queryListeners.addAll(list);
            } else if (type == UpdateEvent.class) {
                this.updateListeners.addAll(list);
            } else if (type == DeleteEvent.class) {
                this.deleteListeners.addAll(list);
            } else {
                this.initListeners.addAll(list);
                this.saveListeners.addAll(list);
                this.queryListeners.addAll(list);
                this.updateListeners.addAll(list);
                this.deleteListeners.addAll(list);
            }
        }
    }

    @Override
    public Query<T> getQuery(Requester requester) {
        Query<T> query = this.getRepository().query();
        this.onQueryEvent(requester, query);
        return query;
    }

    @Override
    public void initObject(Requester requester, T entity, Map<String, Object> parameters) {
        String primary = this.getRepository().getPrimary();
        for (Class<T> model = this.model; model != Object.class; model = model.getSuperclass()) {
            for (Field field : model.getDeclaredFields()) {
                String property = field.getName();
                if (Modifier.isStatic(field.getModifiers()) || property.equals(primary) || !parameters.containsKey(property) || TreeModel.class.isAssignableFrom(model) && (property.equals("key") || property.equals("level") || property.equals("leaf"))) continue;
                Class<Object> type = field.getType();
                if (TreeModel.class.isAssignableFrom(type) && (property.equals("parent") || property.equals("children"))) {
                    type = this.model;
                }
                try {
                    Object value = parameters.get(property);
                    if (Collection.class.isAssignableFrom(type) || !Beans.isMetaClass(type)) {
                        Object current = Beans.getValue(entity, (Field)field);
                        if (Collection.class.isAssignableFrom(type)) {
                            Object[] values = Beans.toArray(Object.class, (Object)value);
                            AbstractCollection objects = Set.class.isAssignableFrom(type) ? new HashSet(values.length) : new ArrayList(values.length);
                            Class[] genericTypes = Beans.getGenericTypes((Field)field);
                            if (genericTypes.length > 0) {
                                Class genericType = genericTypes[0];
                                Repository repository = Repositories.getRepository(genericType);
                                String foreignKey = repository.getPrimary();
                                Class<?> foreignKeyType = Beans.getField((Class)genericType, (String)foreignKey).getType();
                                if (values.length > 0) {
                                    block7: for (Object v : values) {
                                        if (v == null) continue;
                                        if (!genericType.isAssignableFrom(v.getClass())) {
                                            v = Beans.toObject(foreignKeyType, (Object)v);
                                        }
                                        for (Object o : (Collection)current) {
                                            if (!Beans.isEqual((Object)Beans.getValue(o, (String)foreignKey), (Object)v)) continue;
                                            objects.add(o);
                                            continue block7;
                                        }
                                        objects.add(repository.get(v));
                                    }
                                }
                            }
                            value = objects;
                        } else if (value != null && !type.isAssignableFrom(value.getClass())) {
                            Repository<Object> repository = Repositories.getRepository(type);
                            String foreignKey = repository.getPrimary();
                            Class<?> foreignKeyType = Beans.getField(type, (String)foreignKey).getType();
                            value = Beans.toObject(foreignKeyType, (Object)value);
                            value = Beans.isEqual((Object)Beans.getValue((Object)current, (String)foreignKey), (Object)value) ? current : repository.get(value);
                        }
                        Method method = Beans.getSetMethod(model, (Field)field);
                        try {
                            method.invoke(entity, value);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    Beans.setValue(entity, (Field)field, (Object)value);
                }
                catch (IllegalArgumentException e) {
                    throw new ParameterInvalidException(property, e.getMessage());
                }
            }
        }
        this.onInitEvent(requester, entity);
    }

    @Override
    public Serializable saveObject(Requester requester, T object) {
        if (object instanceof Model) {
            Model entity = (Model)object;
            entity.setCreator(requester.getUser());
            if (object instanceof TreeModel) {
                TreeModel tree = (TreeModel)object;
                ArrayList children = new ArrayList(tree.getChildren());
                tree.getChildren().clear();
                Serializable id = this.getRepository().save(object);
                this.onSaveEvent(requester, id, object);
                tree.setId((Integer)id);
                for (int i = 0; i < children.size(); ++i) {
                    TreeModel child = (TreeModel)children.get(i);
                    child.setParent(tree);
                    this.saveObject(requester, child);
                }
                return id;
            }
        }
        Serializable id = this.getRepository().save(object);
        this.onSaveEvent(requester, id, object);
        return id;
    }

    @Override
    public void updateObject(Requester requester, T object) {
        if (object instanceof Model) {
            Model entity = (Model)object;
            entity.setDateUpdate(new Date());
            entity.setUpdater(requester.getUser());
        }
        this.getRepository().update(object);
        this.onUpdateEvent(requester, object);
    }

    @Override
    public void deleteObject(Requester requester, T object) {
        this.getRepository().delete(object);
        this.onDeleteEvent(requester, object);
    }
}

