/*
 * Decompiled with CFR 0.152.
 */
package ars.database.service;

import ars.database.repository.Query;
import ars.database.repository.Repositories;
import ars.database.service.AbstractService;
import ars.database.service.ExcelAdapter;
import ars.database.service.ExportService;
import ars.database.service.ImportService;
import ars.database.service.SimpleExcelAdapter;
import ars.file.office.Excels;
import ars.invoke.request.Requester;
import ars.util.Beans;
import ars.util.Dates;
import ars.util.Files;
import ars.util.Nfile;
import ars.util.Strings;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class StandardGeneralService<T>
extends AbstractService<T> {
    private String directory = Strings.TEMP_PATH;
    private ExcelAdapter<T> excelAdapter = new SimpleExcelAdapter();

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public ExcelAdapter<T> getExcelAdapter() {
        return this.excelAdapter;
    }

    public void setExcelAdapter(ExcelAdapter<T> excelAdapter) {
        this.excelAdapter = excelAdapter;
    }

    protected Map<String, Object> getEffectiveParameters(Map<String, Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        String emptySuffix = "__" + "empty";
        String nonemptySuffix = "__" + "nempty";
        HashMap<String, Object> effectives = new HashMap<String, Object>(parameters.size());
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Beans.isEmpty((Object)value) && !key.endsWith(emptySuffix) && !key.endsWith(nonemptySuffix)) continue;
            effectives.put(key, value);
        }
        return effectives;
    }

    protected Query<T> getQuery(Requester requester, Map<String, Object> parameters) {
        return this.getQuery(requester).custom(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportService.Result import_(final Requester requester, Nfile file, Integer start, final ExcelAdapter<T> adapter, Map<String, Object> parameters) throws Exception {
        long timestamp = System.currentTimeMillis();
        SXSSFWorkbook failed = new SXSSFWorkbook(100);
        final ImportService.Result result = new ImportService.Result();
        String[] titles = start > 0 ? Excels.getTitles((Nfile)file, (int)(start - 1)) : Strings.EMPTY_ARRAY;
        try {
            adapter.begin(requester, this);
            Excels.iteration((Nfile)file, (int)start, (Excels.Reader)new Excels.Reader<T>((Workbook)failed, titles){
                final /* synthetic */ Workbook val$failed;
                final /* synthetic */ String[] val$titles;
                {
                    this.val$failed = workbook;
                    this.val$titles = stringArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T read(Row row) {
                    if (row == null || Excels.isEmpty((Row)row)) {
                        return null;
                    }
                    try {
                        Object entity = adapter.read(requester, StandardGeneralService.this, row);
                        if (entity != null) {
                            StandardGeneralService.this.saveObject(requester, entity);
                        }
                    }
                    catch (Exception e) {
                        result.setFailed(result.getFailed() + 1);
                        Sheet sheet = this.val$failed.getSheetAt(this.val$failed.getNumberOfSheets() - 1);
                        int index = sheet.getLastRowNum() + 1;
                        if (result.getFailed() == 1 || result.getFailed() % 60000 == 1) {
                            sheet = this.val$failed.createSheet();
                            Excels.setTitles((Row)sheet.createRow(0), (String[])this.val$titles);
                            index = 1;
                        }
                        Row target = sheet.createRow(index);
                        Excels.copy((Row)row, (Row)target);
                        int columns = this.val$titles.length > 0 ? this.val$titles.length : row.getLastCellNum();
                        Excels.setValue((Cell)target.createCell(columns), (Object)e.getMessage());
                    }
                    finally {
                        result.setTotal(result.getTotal() + 1);
                    }
                    return null;
                }
            });
            if (result.getFailed() > 0) {
                String name = UUID.randomUUID().toString() + ".xlsx";
                File attachment = new File(this.directory, name);
                Excels.write((Workbook)failed, (File)attachment);
                result.setFile(name);
                result.setSize(Files.getUnitSize((long)attachment.length()));
            }
        }
        finally {
            failed.close();
            adapter.complete(requester, this);
        }
        result.setSpend(Dates.getUnitTime((long)(System.currentTimeMillis() - timestamp)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportService.Result export(Requester requester, ExcelAdapter<T> adapter, Map<String, Object> parameters) throws Exception {
        parameters = requester.getParameters();
        Integer page = Beans.toInteger(Integer.class, parameters.remove("__page"));
        Integer size = Beans.toInteger(Integer.class, parameters.remove("__size"));
        long timestamp = System.currentTimeMillis();
        ExportService.Result result = new ExportService.Result();
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        try {
            adapter.begin(requester, this);
            Sheet sheet = workbook.createSheet();
            String[] titles = adapter.getTitles(requester, this);
            Excels.setTitles((Row)sheet.createRow(0), (String[])titles);
            if (page == null || size == null) {
                int count = this.getQuery(requester, parameters).count();
                int length = 1000;
                int pages = count / length;
                int remain = count % length;
                if (remain > 0) {
                    ++pages;
                }
                int total = 1;
                for (int i = 1; i < pages + 1; ++i) {
                    if (total > 1 && total % 60000 == 1) {
                        sheet = workbook.createSheet();
                        Excels.setTitles((Row)sheet.createRow(0), (String[])titles);
                    }
                    int end = i * length;
                    List<T> objects = this.getQuery(requester, parameters).paging(i, end > count ? remain : length).list();
                    for (int n = 0; n < objects.size(); ++n) {
                        adapter.write(requester, this, objects.get(n), sheet.createRow(n + 1));
                        result.setTotal(result.getTotal() + 1);
                    }
                }
            } else {
                List<T> objects = this.getQuery(requester, parameters).paging(page, size).list();
                for (int i = 0; i < objects.size(); ++i) {
                    adapter.write(requester, this, objects.get(i), sheet.createRow(i + 1));
                }
            }
            String name = UUID.randomUUID().toString() + ".xlsx";
            File attachment = new File(this.directory, name);
            Excels.write((Workbook)workbook, (File)attachment);
            result.setFile(name);
            result.setSize(Files.getUnitSize((long)attachment.length()));
            result.setSpend(Dates.getUnitTime((long)(System.currentTimeMillis() - timestamp)));
        }
        finally {
            workbook.close();
            adapter.complete(requester, this);
        }
        return result;
    }

    public Serializable add(Requester requester, Map<String, Object> parameters) {
        Object entity = Beans.getInstance(this.getModel());
        this.initObject(requester, entity, parameters);
        return this.saveObject(requester, entity);
    }

    public void delete(Requester requester, Map<String, Object> parameters) {
        Map<String, Object> effectives = this.getEffectiveParameters(parameters);
        if (!effectives.isEmpty()) {
            List<T> entities = this.getQuery(requester, effectives).list();
            for (int i = 0; i < entities.size(); ++i) {
                this.deleteObject(requester, entities.get(i));
            }
        }
    }

    public void update(Requester requester, Map<String, Object> parameters) {
        String primary = this.getRepository().getPrimary();
        Object[] identifiers = Beans.toArray(Object.class, (Object)parameters.get(primary));
        if (identifiers.length > 0) {
            List entities = this.getQuery(requester).or(primary, identifiers).list();
            for (int i = 0; i < entities.size(); ++i) {
                Object entity = entities.get(i);
                this.initObject(requester, entity, parameters);
                this.updateObject(requester, entity);
            }
        }
    }

    public int count(Requester requester, Map<String, Object> parameters) {
        Map<String, Object> effectives = this.getEffectiveParameters(parameters);
        effectives.remove("__page");
        effectives.remove("__size");
        return this.getQuery(requester, effectives).count();
    }

    public List<?> stats(Requester requester, Map<String, Object> parameters) {
        return this.getQuery(requester, parameters).stats();
    }

    public T object(Requester requester, Map<String, Object> parameters) {
        Map<String, Object> effectives = this.getEffectiveParameters(parameters);
        if (effectives.isEmpty()) {
            return null;
        }
        return this.getQuery(requester, effectives).single();
    }

    public List<T> objects(Requester requester, Map<String, Object> parameters) {
        return this.getQuery(requester, parameters).list();
    }

    public List<T> trees(Requester requester, Map<String, Object> parameters) {
        List<T> objects = this.getQuery(requester, parameters).list();
        return Repositories.mergeTrees(objects);
    }

    public ImportService.Result import_(Requester requester, Nfile file, Integer start, Map<String, Object> parameters) throws Exception {
        return this.import_(requester, file, start, this.excelAdapter, parameters);
    }

    public ExportService.Result export(Requester requester, Map<String, Object> parameters) throws Exception {
        return this.export(requester, this.excelAdapter, parameters);
    }

    public Nfile file(Requester requester, String name, Map<String, Object> parameters) {
        return new Nfile(new File(this.directory, name));
    }
}

