/*
 * Decompiled with CFR 0.152.
 */
package ars.database.spring;

import ars.database.activiti.ActivityNode;
import ars.database.activiti.ProcessConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ActivitiEngineConfiguration
extends SpringProcessEngineConfiguration
implements ProcessConfiguration,
ApplicationListener<ApplicationEvent> {
    private boolean deploied;
    private Map<Class<?>, String> keys = new HashMap();
    private Map<Class<?>, String> processes = new HashMap();
    private Map<Class<?>, String> identifiers = new HashMap();
    private Map<String, List<ActivityNode>> nodes = new HashMap<String, List<ActivityNode>>();

    public Map<Class<?>, String> getProcesses() {
        return this.processes;
    }

    public void setProcesses(Map<Class<?>, String> processes) {
        this.processes = processes;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        ArrayList listeners = new ArrayList(applicationContext.getBeansOfType(ActivitiEventListener.class).values());
        this.setEventListeners(listeners);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && !this.deploied) {
            this.deploied = true;
            this.deploy(this.processes);
        }
    }

    @Override
    public String getKey(Class<?> model) {
        return this.keys.get(model);
    }

    @Override
    public String getIdentifier(Class<?> model) {
        return this.identifiers.get(model);
    }

    @Override
    public List<ActivityNode> getNodes(Class<?> model) {
        List<ActivityNode> nodes = this.nodes.get(this.getKey(model));
        return nodes == null ? new ArrayList<ActivityNode>(0) : new ArrayList<ActivityNode>(nodes);
    }

    @Override
    public ActivityNode getNode(Class<?> model, int id) {
        List<ActivityNode> nodes = this.nodes.get(this.getKey(model));
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        for (ActivityNode node : nodes) {
            if (node.getId() != id) continue;
            return node;
        }
        return null;
    }

    @Override
    public ActivityNode getNode(Class<?> model, String code) {
        List<ActivityNode> nodes = this.nodes.get(this.getKey(model));
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        for (ActivityNode node : nodes) {
            if (!node.getCode().equals(code)) continue;
            return node;
        }
        return null;
    }

    @Override
    public void deploy(Map<Class<?>, String> processes) {
        RepositoryService repositoryService = this.getRepositoryService();
        HashMap resources = new HashMap(0);
        for (Map.Entry<Class<?>, String> entry : processes.entrySet()) {
            Class<?> model = entry.getKey();
            String resource = entry.getValue();
            resources.put(resource, model);
            String name = model.getName();
            Long count = repositoryService.createDeploymentQuery().deploymentName(name).count();
            if (count != null && count > 0L) continue;
            repositoryService.createDeployment().name(name).addClasspathResource(resource).deploy();
        }
        List definitions = ((ProcessDefinitionQuery)repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        for (int i = 0; i < definitions.size(); ++i) {
            ProcessDefinition definition = (ProcessDefinition)definitions.get(i);
            Class model = (Class)resources.get(definition.getResourceName());
            this.keys.put(model, definition.getKey());
            this.identifiers.put(model, definition.getId());
            BpmnModel bpmnModel = repositoryService.getBpmnModel(definition.getId());
            if (bpmnModel == null) continue;
            int index = 1;
            FlowElement startEvent = null;
            FlowElement endEvent = null;
            LinkedList<ActivityNode> nodes = new LinkedList<ActivityNode>();
            Collection elements = bpmnModel.getMainProcess().getFlowElements();
            for (FlowElement element : elements) {
                if (element instanceof StartEvent) {
                    startEvent = element;
                    continue;
                }
                if (element instanceof EndEvent) {
                    endEvent = element;
                    continue;
                }
                if (!(element instanceof UserTask)) continue;
                nodes.add(new ActivityNode(index++, element.getId(), element.getName()));
            }
            if (startEvent == null) {
                throw new RuntimeException("Start element not found");
            }
            if (endEvent == null) {
                throw new RuntimeException("End element not found");
            }
            nodes.addFirst(new ActivityNode(0, startEvent.getId(), startEvent.getName()));
            nodes.add(new ActivityNode(index, endEvent.getId(), endEvent.getName()));
            this.nodes.put(definition.getKey(), nodes);
        }
    }
}

