/*
 * Decompiled with CFR 0.152.
 */
package ars.database.spring;

import ars.database.repository.DataConstraintException;
import ars.database.repository.Repositories;
import ars.database.repository.Repository;
import ars.database.repository.RepositoryFactory;
import ars.database.service.Service;
import ars.database.service.ServiceFactory;
import ars.database.service.Services;
import ars.database.service.WorkflowService;
import ars.database.service.event.ServiceEvent;
import ars.database.service.event.ServiceListener;
import ars.invoke.convert.ThrowableResolver;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DatabaseConfiguration
implements ThrowableResolver,
ServiceFactory,
RepositoryFactory,
ApplicationContextAware {
    public static final int CODE_ERROR_DATA_CONSTRAINT = 52070;
    private Map<Class<?>, Service<?>> services = Collections.emptyMap();
    private Map<Class<?>, Repository<?>> repositories = Collections.emptyMap();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Services.setServiceFactory(this);
        Repositories.setRepositoryFactory(this);
        Collection repositories = applicationContext.getBeansOfType(Repository.class).values();
        this.repositories = new HashMap(repositories.size());
        for (Object repository : repositories) {
            this.repositories.put(repository.getModel(), (Repository<?>)repository);
        }
        Collection services = applicationContext.getBeansOfType(Service.class).values();
        this.services = new HashMap(services.size());
        for (Service service : services) {
            if (service instanceof WorkflowService) {
                ProcessEngine processEngine = (ProcessEngine)applicationContext.getBean(ProcessEngine.class);
                ((WorkflowService)service).setProcessEngine(processEngine);
            }
            this.services.put(service.getModel(), service);
        }
        Collection listeners = applicationContext.getBeansOfType(ServiceListener.class).values();
        HashMap listenerGroups = new HashMap();
        try {
            for (ServiceListener listener : listeners) {
                ServiceListener target = null;
                if (AopUtils.isAopProxy((Object)listener)) {
                    target = (ServiceListener)((Advised)listener).getTargetSource().getTarget();
                }
                Class<?> etype = null;
                for (Method method : (target == null ? listener : target).getClass().getMethods()) {
                    if (!method.getName().equals("onServiceEvent") || etype != null && etype != ServiceEvent.class) continue;
                    etype = method.getParameterTypes()[0];
                }
                LinkedList<ServiceListener> listenerGroup = (LinkedList<ServiceListener>)listenerGroups.get(etype);
                if (listenerGroup == null) {
                    listenerGroup = new LinkedList<ServiceListener>();
                    listenerGroups.put(etype, listenerGroup);
                }
                listenerGroup.add(listener);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : listenerGroups.entrySet()) {
            ServiceListener[] listenerGroup = ((List)entry.getValue()).toArray(new ServiceListener[0]);
            for (Service service : services) {
                service.addListeners((Class)entry.getKey(), listenerGroup);
            }
        }
    }

    public int getCode(Throwable throwable) {
        return 52070;
    }

    public String getMessage(Throwable throwable) {
        return throwable.getMessage();
    }

    public boolean isResolvable(Throwable throwable) {
        return throwable != null && throwable instanceof DataConstraintException;
    }

    @Override
    public Map<Class<?>, Service<?>> getServices() {
        return Collections.unmodifiableMap(this.services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Service<T> getService(Class<T> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        Service<?> service = this.services.get(model);
        if (service == null) {
            Class<T> clazz = model;
            synchronized (clazz) {
                service = this.services.get(model);
                if (service == null) {
                    for (Map.Entry<Class<?>, Service<?>> entry : this.services.entrySet()) {
                        if (!entry.getKey().isAssignableFrom(model)) continue;
                        service = entry.getValue();
                        this.services.put(model, service);
                    }
                }
            }
        }
        if (service == null) {
            throw new RuntimeException("Service not found:" + model);
        }
        return service;
    }

    @Override
    public Map<Class<?>, Repository<?>> getRepositories() {
        return Collections.unmodifiableMap(this.repositories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Repository<T> getRepository(Class<T> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        Repository<?> repository = this.repositories.get(model);
        if (repository == null) {
            Class<T> clazz = model;
            synchronized (clazz) {
                repository = this.repositories.get(model);
                if (repository == null) {
                    for (Map.Entry<Class<?>, Repository<?>> entry : this.repositories.entrySet()) {
                        if (!entry.getKey().isAssignableFrom(model)) continue;
                        repository = entry.getValue();
                        this.repositories.put(model, repository);
                    }
                }
            }
        }
        if (repository == null) {
            throw new RuntimeException("Repository not found:" + model);
        }
        return repository;
    }
}

