/*
 * Decompiled with CFR 0.152.
 */
package ars.database.spring;

import ars.database.repository.Query;
import ars.database.repository.Repositories;
import ars.util.Beans;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;

public class EntityFactoryBean
implements FactoryBean<Object> {
    private Object entity;
    private boolean loaded;
    private Class<?> model;
    private boolean multiple;
    private Map<String, Object> attributes;

    public Class<?> getModel() {
        return this.model;
    }

    public void setModel(Class<?> model) {
        this.model = model;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Object getObject() throws Exception {
        if (!this.loaded) {
            if (this.model == null) {
                throw new RuntimeException("Model has not been initialize");
            }
            if (this.attributes == null || this.attributes.isEmpty()) {
                throw new RuntimeException("Attributes has not been initialize");
            }
            this.loaded = true;
            Query<?> query = Repositories.query(this.model).custom(this.attributes);
            if (this.multiple) {
                List<?> objects = query.list();
                if (Beans.isEmpty((Object)this.entity) || !objects.isEmpty()) {
                    this.entity = objects;
                }
            } else {
                Object object = query.single();
                if (Beans.isEmpty((Object)this.entity) || object != null) {
                    this.entity = object;
                }
            }
        }
        return this.entity;
    }

    public Class<?> getObjectType() {
        return this.multiple ? List.class : this.model;
    }

    public boolean isSingleton() {
        return true;
    }
}

