/*
 * Decompiled with CFR 0.152.
 */
package ars.database.spring;

import ars.database.hibernate.HibernateSimpleRepository;
import ars.database.hibernate.Hibernates;
import ars.database.model.TreeModel;
import ars.database.repository.DataConstraintException;
import ars.database.repository.Repositories;
import ars.database.repository.Repository;
import ars.database.service.event.DeleteEvent;
import ars.database.service.event.InitEvent;
import ars.database.service.event.ServiceEvent;
import ars.database.service.event.ServiceListener;
import ars.database.spring.DatabaseConfiguration;
import ars.invoke.request.ParameterInvalidException;
import ars.util.Beans;
import ars.util.Conditions;
import ars.util.ObjectAdapter;
import ars.util.Strings;
import ars.util.Tree;
import ars.util.Trees;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;

public class HibernateDatabaseConfiguration
extends DatabaseConfiguration
implements ObjectAdapter,
ServiceListener<ServiceEvent> {
    private static Map<Class<?>, List<Property>> VALIDATE_MODEL_PROPERTY_MAPPING = new HashMap();
    private static Map<Class<?>, Map<Class<?>, List<Property>>> VALIDATE_MODEL_RELATE_MAPPING = new HashMap();
    private String validate;

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    protected void validation(InitEvent event) {
        Class<?> superclass;
        Object entity = event.getEntity();
        Class<?> model = event.getService().getModel();
        while ((superclass = model.getSuperclass()) != Object.class && !Modifier.isAbstract(superclass.getModifiers()) && VALIDATE_MODEL_PROPERTY_MAPPING.containsKey(superclass)) {
            model = superclass;
        }
        Repository<?> repository = Repositories.getRepository(model);
        List<Property> properties = VALIDATE_MODEL_PROPERTY_MAPPING.get(model);
        if (properties == null) {
            throw new RuntimeException("Unknown model:" + model.getName());
        }
        LinkedList<Conditions.Condition> uniques = new LinkedList<Conditions.Condition>();
        for (Property property : properties) {
            String name = property.getName();
            Object value = Beans.getValue((Object)entity, (String)name);
            Iterator columnIterator = property.getColumnIterator();
            if (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                if (!column.isNullable() && Beans.isEmpty((Object)value)) {
                    throw new ParameterInvalidException(name, "required");
                }
                if (column.isUnique() && !Beans.isEmpty((Object)value)) {
                    uniques.add(new Conditions.Condition(name, value));
                }
            }
            if (!(entity instanceof TreeModel) || !name.equals("parent") || !Trees.isLoop((Tree)((TreeModel)entity))) continue;
            throw new ParameterInvalidException(name, "dead cycle");
        }
        if (!uniques.isEmpty()) {
            Object id = Beans.getValue((Object)entity, (String)repository.getPrimary());
            Object exist = repository.query().ne(repository.getPrimary(), id).condition((Conditions.Logic)new Conditions.Or((Conditions.Logic[])uniques.toArray(new Conditions.Condition[0]))).single();
            if (exist != null) {
                for (Conditions.Condition condition : uniques) {
                    if (!Beans.isEqual((Object)Beans.getValue(exist, (String)condition.getKey()), (Object)condition.getValue())) continue;
                    throw new ParameterInvalidException(condition.getKey(), "exist");
                }
            }
        }
    }

    protected void validation(DeleteEvent event) {
        Object entity = event.getEntity();
        Class<?> model = event.getService().getModel();
        Map<Class<?>, List<Property>> relates = VALIDATE_MODEL_RELATE_MAPPING.get(model);
        if (relates != null && !relates.isEmpty()) {
            for (Map.Entry<Class<?>, List<Property>> entry : relates.entrySet()) {
                Class<?> foreignKeyClass = entry.getKey();
                Repository<?> repository = Repositories.getRepository(foreignKeyClass);
                for (Property property : entry.getValue()) {
                    Object relate;
                    if (TreeModel.class.isAssignableFrom(model) && model == foreignKeyClass && property.getName().equals("parent") || (relate = repository.query().eq(property.getName(), entity).paging(1, 1).single()) == null) continue;
                    String message = event.getSource().format(foreignKeyClass.getName()) + '\u3010' + relate.toString() + '\u3011';
                    throw new DataConstraintException(message);
                }
            }
        }
    }

    protected void bindSessionFactory(ApplicationContext applicationContext) {
        Collection sessionFactories = applicationContext.getBeansOfType(SessionFactory.class).values();
        HashMap<Class, SessionFactory> modelSessionFactoryMappings = new HashMap<Class, SessionFactory>();
        for (SessionFactory sessionFactory : sessionFactories) {
            Collection classMetadatas = sessionFactory.getAllClassMetadata().values();
            for (ClassMetadata classMetadata : classMetadatas) {
                modelSessionFactoryMappings.put(classMetadata.getMappedClass(), sessionFactory);
            }
        }
        Map repositories = applicationContext.getBeansOfType(Repository.class);
        for (Map.Entry entry : repositories.entrySet()) {
            Repository repository = (Repository)entry.getValue();
            if (AopUtils.isAopProxy((Object)repository)) {
                try {
                    repository = (Repository)((Advised)repository).getTargetSource().getTarget();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(repository instanceof HibernateSimpleRepository)) continue;
            Class model = repository.getModel();
            SessionFactory sessionFactory = (SessionFactory)modelSessionFactoryMappings.get(model);
            if (sessionFactory == null) {
                throw new RuntimeException("No matching session factory:" + model);
            }
            ((HibernateSimpleRepository)repository).setSessionFactory(sessionFactory);
        }
    }

    protected void bindValidateProperty(ApplicationContext applicationContext) {
        Collection sessionFactoryBeans = applicationContext.getBeansOfType(LocalSessionFactoryBean.class).values();
        for (LocalSessionFactoryBean bean : sessionFactoryBeans) {
            Class mappedClass;
            PersistentClass persistent;
            SessionFactory sessionFactory = bean.getObject();
            Configuration configuration = bean.getConfiguration();
            Iterator persistentIterator = configuration.getClassMappings();
            while (persistentIterator.hasNext()) {
                persistent = (PersistentClass)persistentIterator.next();
                mappedClass = persistent.getMappedClass();
                if (this.validate != null && !Strings.matches((String)mappedClass.getName(), (String)this.validate)) continue;
                List<Property> mappedProperties = VALIDATE_MODEL_PROPERTY_MAPPING.get(mappedClass);
                if (mappedProperties == null) {
                    mappedProperties = new LinkedList<Property>();
                    VALIDATE_MODEL_PROPERTY_MAPPING.put(mappedClass, mappedProperties);
                }
                Iterator propertyIterator = persistent.getPropertyIterator();
                while (propertyIterator.hasNext()) {
                    List<Property> properties;
                    Property property = (Property)propertyIterator.next();
                    String name = property.getName();
                    if (TreeModel.class.isAssignableFrom(mappedClass) && (name.equals("key") || name.equals("level") || name.equals("leaf") || name.equals("parent") || name.equals("children"))) continue;
                    mappedProperties.add(property);
                    Type type = property.getType();
                    Class<?> foreignKeyClass = Hibernates.getPropertyTypeClass(sessionFactory, type);
                    if (this.validate != null && !Strings.matches((String)foreignKeyClass.getName(), (String)this.validate) || !type.isEntityType() && !type.isCollectionType()) continue;
                    Map<Class<?>, List<Property>> relates = VALIDATE_MODEL_RELATE_MAPPING.get(foreignKeyClass);
                    if (relates == null) {
                        relates = new HashMap();
                        VALIDATE_MODEL_RELATE_MAPPING.put(foreignKeyClass, relates);
                    }
                    if ((properties = relates.get(mappedClass)) == null) {
                        properties = new LinkedList<Property>();
                        relates.put(mappedClass, properties);
                    }
                    properties.add(property);
                }
            }
            persistentIterator = configuration.getClassMappings();
            while (persistentIterator.hasNext()) {
                Map<Class<?>, List<Property>> superrelates;
                persistent = (PersistentClass)persistentIterator.next();
                mappedClass = persistent.getMappedClass();
                Map<Class<?>, List<Property>> relates = VALIDATE_MODEL_RELATE_MAPPING.get(mappedClass);
                if (relates == null) continue;
                for (Class superclass = mappedClass.getSuperclass(); superclass != Object.class && !Modifier.isAbstract(superclass.getModifiers()) && (superrelates = VALIDATE_MODEL_RELATE_MAPPING.get(superclass)) != null; superclass = superclass.getSuperclass()) {
                    List<Property> properties;
                    Class<?> key;
                    for (Map.Entry<Class<?>, List<Property>> entry : relates.entrySet()) {
                        key = entry.getKey();
                        properties = superrelates.get(key);
                        if (properties == null) {
                            properties = new LinkedList<Property>();
                            superrelates.put(key, properties);
                        }
                        for (Property property : entry.getValue()) {
                            if (properties.contains(property)) continue;
                            properties.add(property);
                        }
                    }
                    for (Map.Entry<Class<?>, List<Property>> entry : superrelates.entrySet()) {
                        key = entry.getKey();
                        properties = relates.get(key);
                        if (properties == null) {
                            properties = new LinkedList<Property>();
                            relates.put(key, properties);
                        }
                        for (Property property : entry.getValue()) {
                            if (properties.contains(property)) continue;
                            properties.add(property);
                        }
                    }
                }
            }
        }
    }

    protected void registerEventListener(ApplicationContext applicationContext) {
        Collection sessionFactories = applicationContext.getBeansOfType(SessionFactory.class).values();
        for (SessionFactory sessionFactory : sessionFactories) {
            Map initializeCollectionEventListeners;
            Map saveOrUpdateEventListeners;
            Map flushEntityEventListeners;
            Map postInsertEventListeners;
            Map postDeleteEventListeners;
            Map postUpdateEventListeners;
            Map dirtyCheckEventListeners;
            Map replicateEventListeners;
            Map preInsertEventListeners;
            Map preDeleteEventListeners;
            Map preUpdateEventListeners;
            Map autoFlushEventListeners;
            Map postLoadEventListeners;
            Map preLoadEventListeners;
            Map refreshEventListeners;
            Map persistEventListeners;
            Map deleteEventListeners;
            Map flushEventListeners;
            Map evictEventListeners;
            Map mergeEventListeners;
            Map lockEventListeners;
            EventListenerRegistry registry = (EventListenerRegistry)((SessionFactoryImpl)sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
            Map loadEventListeners = applicationContext.getBeansOfType(LoadEventListener.class);
            if (!loadEventListeners.isEmpty()) {
                registry.appendListeners(EventType.LOAD, (Object[])loadEventListeners.values().toArray(new LoadEventListener[0]));
            }
            if (!(lockEventListeners = applicationContext.getBeansOfType(LockEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.LOCK, (Object[])lockEventListeners.values().toArray(new LockEventListener[0]));
            }
            if (!(mergeEventListeners = applicationContext.getBeansOfType(MergeEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.MERGE, (Object[])mergeEventListeners.values().toArray(new MergeEventListener[0]));
            }
            if (!(evictEventListeners = applicationContext.getBeansOfType(EvictEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.EVICT, (Object[])evictEventListeners.values().toArray(new EvictEventListener[0]));
            }
            if (!(flushEventListeners = applicationContext.getBeansOfType(FlushEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.FLUSH, (Object[])flushEventListeners.values().toArray(new FlushEventListener[0]));
            }
            if (!(deleteEventListeners = applicationContext.getBeansOfType(DeleteEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.DELETE, (Object[])deleteEventListeners.values().toArray(new DeleteEventListener[0]));
            }
            if (!(persistEventListeners = applicationContext.getBeansOfType(PersistEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.PERSIST, (Object[])persistEventListeners.values().toArray(new PersistEventListener[0]));
            }
            if (!(refreshEventListeners = applicationContext.getBeansOfType(RefreshEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.REFRESH, (Object[])refreshEventListeners.values().toArray(new RefreshEventListener[0]));
            }
            if (!(preLoadEventListeners = applicationContext.getBeansOfType(PreLoadEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.PRE_LOAD, (Object[])preLoadEventListeners.values().toArray(new PreLoadEventListener[0]));
            }
            if (!(postLoadEventListeners = applicationContext.getBeansOfType(PostLoadEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.POST_LOAD, (Object[])postLoadEventListeners.values().toArray(new PostLoadEventListener[0]));
            }
            if (!(autoFlushEventListeners = applicationContext.getBeansOfType(AutoFlushEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.AUTO_FLUSH, (Object[])autoFlushEventListeners.values().toArray(new AutoFlushEventListener[0]));
            }
            if (!(preUpdateEventListeners = applicationContext.getBeansOfType(PreUpdateEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.PRE_UPDATE, (Object[])preUpdateEventListeners.values().toArray(new PreUpdateEventListener[0]));
            }
            if (!(preDeleteEventListeners = applicationContext.getBeansOfType(PreDeleteEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.PRE_DELETE, (Object[])preDeleteEventListeners.values().toArray(new PreDeleteEventListener[0]));
            }
            if (!(preInsertEventListeners = applicationContext.getBeansOfType(PreInsertEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.PRE_INSERT, (Object[])preInsertEventListeners.values().toArray(new PreInsertEventListener[0]));
            }
            if (!(replicateEventListeners = applicationContext.getBeansOfType(ReplicateEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.REPLICATE, (Object[])replicateEventListeners.values().toArray(new ReplicateEventListener[0]));
            }
            if (!(dirtyCheckEventListeners = applicationContext.getBeansOfType(DirtyCheckEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.DIRTY_CHECK, (Object[])dirtyCheckEventListeners.values().toArray(new DirtyCheckEventListener[0]));
            }
            if (!(postUpdateEventListeners = applicationContext.getBeansOfType(PostUpdateEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.POST_UPDATE, (Object[])postUpdateEventListeners.values().toArray(new PostUpdateEventListener[0]));
            }
            if (!(postDeleteEventListeners = applicationContext.getBeansOfType(PostDeleteEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.POST_DELETE, (Object[])postDeleteEventListeners.values().toArray(new PostDeleteEventListener[0]));
            }
            if (!(postInsertEventListeners = applicationContext.getBeansOfType(PostInsertEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.POST_INSERT, (Object[])postInsertEventListeners.values().toArray(new PostInsertEventListener[0]));
            }
            if (!(flushEntityEventListeners = applicationContext.getBeansOfType(FlushEntityEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.FLUSH_ENTITY, (Object[])flushEntityEventListeners.values().toArray(new FlushEntityEventListener[0]));
            }
            if (!(saveOrUpdateEventListeners = applicationContext.getBeansOfType(SaveOrUpdateEventListener.class)).isEmpty()) {
                registry.appendListeners(EventType.SAVE_UPDATE, (Object[])saveOrUpdateEventListeners.values().toArray(new SaveOrUpdateEventListener[0]));
            }
            if ((initializeCollectionEventListeners = applicationContext.getBeansOfType(InitializeCollectionEventListener.class)).isEmpty()) continue;
            registry.appendListeners(EventType.INIT_COLLECTION, (Object[])initializeCollectionEventListeners.values().toArray(new InitializeCollectionEventListener[0]));
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.bindSessionFactory(applicationContext);
        this.bindValidateProperty(applicationContext);
        this.registerEventListener(applicationContext);
    }

    public Object adaption(Object object) {
        if (Hibernate.isInitialized((Object)object)) {
            return object;
        }
        if (object instanceof Map) {
            return Collections.emptyMap();
        }
        if (object instanceof Set) {
            return Collections.emptySet();
        }
        if (object instanceof List) {
            return Collections.emptyList();
        }
        return null;
    }

    @Override
    public void onServiceEvent(ServiceEvent event) {
        Class<?> model = event.getService().getModel();
        if (this.validate == null || Strings.matches((String)model.getName(), (String)this.validate)) {
            if (event instanceof InitEvent) {
                this.validation((InitEvent)event);
            } else if (event instanceof DeleteEvent) {
                this.validation((DeleteEvent)event);
            }
        }
    }
}

