/*
 * Decompiled with CFR 0.152.
 */
package ars.database.hibernate;

import ars.database.hibernate.DetachedCriteriaQuery;
import ars.database.repository.AbstractRepository;
import ars.database.repository.Query;
import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateSimpleRepository<T>
extends AbstractRepository<T> {
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Session getSession() {
        if (this.sessionFactory == null) {
            throw new RuntimeException("Session factory has not been initialize");
        }
        Session session = this.sessionFactory.getCurrentSession();
        session.clear();
        return session;
    }

    @Override
    protected void modify(T object) {
        if (object != null) {
            this.getSession().update(object);
        }
    }

    @Override
    protected Serializable insert(T object) {
        return object == null ? null : this.getSession().save(object);
    }

    @Override
    protected void remove(T object) {
        if (object != null) {
            this.getSession().delete(object);
        }
    }

    @Override
    public Query<T> query() {
        return new DetachedCriteriaQuery(this.sessionFactory, this.getModel());
    }
}

