/*
 * Decompiled with CFR 0.152.
 */
package ars.database.hibernate;

import ars.database.hibernate.DetachedCriteriaQuery;
import ars.database.model.Model;
import ars.database.model.TreeModel;
import ars.database.repository.Query;
import ars.util.Beans;
import ars.util.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public final class Hibernates {
    private Hibernates() {
    }

    public static ClassMetadata getClassMetadata(SessionFactory sessionFactory, Class<?> model) {
        ClassMetadata metadata = sessionFactory.getClassMetadata(model);
        if (metadata == null) {
            throw new RuntimeException("Class metadata not found:" + model.getName());
        }
        return metadata;
    }

    public static String getPrimary(SessionFactory sessionFactory, Class<?> model) {
        return Hibernates.getClassMetadata(sessionFactory, model).getIdentifierPropertyName();
    }

    public static Class<?> getPrimaryClass(SessionFactory sessionFactory, Class<?> model) {
        return Hibernates.getClassMetadata(sessionFactory, model).getIdentifierType().getReturnedClass();
    }

    public static Serializable getIdentifier(SessionFactory sessionFactory, Object object) {
        return object == null ? null : (object instanceof Model ? ((Model)object).getId() : (Serializable)Beans.getValue((Object)object, (String)Hibernates.getPrimary(sessionFactory, object.getClass())));
    }

    public static void setIdentifier(SessionFactory sessionFactory, Object object, Object id) {
        if (object != null && id != null) {
            if (object instanceof Model) {
                ((Model)object).setId(Beans.toInteger(Integer.TYPE, (Object)id));
            } else {
                Beans.setValue((Object)object, (String)Hibernates.getPrimary(sessionFactory, object.getClass()), (Object)id);
            }
        }
    }

    public static String[] getProperties(SessionFactory sessionFactory, Class<?> model) {
        return Hibernates.getClassMetadata(sessionFactory, model).getPropertyNames();
    }

    public static Class<?> getPropertyTypeClass(SessionFactory sessionFactory, Type type) {
        return type.isCollectionType() ? ((CollectionType)type).getElementType((SessionFactoryImplementor)sessionFactory).getReturnedClass() : type.getReturnedClass();
    }

    public static Type getPropertyType(SessionFactory sessionFactory, Class<?> model, String property) {
        int index = property.indexOf(46);
        if (index > 0) {
            Type type = Hibernates.getPropertyType(sessionFactory, model, property.substring(0, index));
            return Hibernates.getPropertyType(sessionFactory, Hibernates.getPropertyTypeClass(sessionFactory, type), property.substring(index + 1));
        }
        ClassMetadata metadata = Hibernates.getClassMetadata(sessionFactory, model);
        if (metadata.hasIdentifierProperty() && metadata.getIdentifierPropertyName().equals(property)) {
            return metadata.getIdentifierType();
        }
        return metadata.getPropertyType(property);
    }

    public static Class<?> getPropertyClass(SessionFactory sessionFactory, Class<?> model, String property) {
        Type type = Hibernates.getPropertyType(sessionFactory, model, property);
        return Hibernates.getPropertyTypeClass(sessionFactory, type);
    }

    public static Object getValue(SessionFactory sessionFactory, Object object, String property) {
        if (object == null) {
            return null;
        }
        ClassMetadata metadata = Hibernates.getClassMetadata(sessionFactory, object.getClass());
        Object value = metadata.getPropertyValue(object, property);
        if (value != null && !Hibernate.isInitialized((Object)value)) {
            Type type = metadata.getPropertyType(property);
            return type.isCollectionType() ? new ArrayList(0) : null;
        }
        return value;
    }

    public static Map<String, Object> getValues(SessionFactory sessionFactory, Object object, String ... properties) {
        if (object == null) {
            return new HashMap<String, Object>(0);
        }
        if (properties == null || properties.length == 0) {
            properties = Hibernates.getProperties(sessionFactory, object.getClass());
        }
        HashMap<String, Object> values = new HashMap<String, Object>(properties.length);
        for (String property : properties) {
            values.put(property, Hibernates.getValue(sessionFactory, object, property));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(SessionFactory sessionFactory, Object object, String property, Object value) {
        if (object == null) {
            return;
        }
        ClassMetadata metadata = Hibernates.getClassMetadata(sessionFactory, object.getClass());
        Type type = metadata.getPropertyType(property);
        Class<?> meta = Hibernates.getPropertyTypeClass(sessionFactory, type);
        if (type.isEntityType()) {
            if (value != null && !meta.isAssignableFrom(value.getClass())) {
                Serializable id = (Serializable)Beans.toObject(Hibernates.getPrimaryClass(sessionFactory, meta), (Object)value);
                Session session = sessionFactory.openSession();
                try {
                    value = session.get(meta, id);
                }
                finally {
                    session.close();
                }
            }
            metadata.setPropertyValue(object, property, value);
        } else if (type.isCollectionType()) {
            AbstractCollection objects;
            Object[] values = Beans.toArray(Object.class, (Object)value);
            AbstractCollection abstractCollection = objects = Set.class.isAssignableFrom(type.getReturnedClass()) ? new HashSet(values.length) : new ArrayList(values.length);
            if (values.length > 0) {
                Session session = null;
                Class<?> foreignPrimaryClass = Hibernates.getPrimaryClass(sessionFactory, meta);
                try {
                    for (Object v : values) {
                        if (v != null && !meta.isAssignableFrom(v.getClass())) {
                            if (session == null) {
                                session = sessionFactory.openSession();
                            }
                            Serializable id = (Serializable)Beans.toObject(foreignPrimaryClass, (Object)v);
                            v = session.get(meta, id);
                        }
                        if (v == null) continue;
                        objects.add(v);
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            metadata.setPropertyValue(object, property, objects);
        }
        metadata.setPropertyValue(object, property, Beans.toObject(meta, (Object)value));
    }

    public static void setValues(SessionFactory sessionFactory, Object object, Map<String, Object> parameters) {
        if (object != null && parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                Hibernates.setValue(sessionFactory, object, entry.getKey(), entry.getValue());
            }
        }
    }

    public static <T> Query<T> query(SessionFactory sessionFactory, Class<T> model) {
        if (sessionFactory == null) {
            throw new IllegalArgumentException("Illegal sessionFactory:" + sessionFactory);
        }
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        return new DetachedCriteriaQuery<T>(sessionFactory, model);
    }

    public static void createRepositoryResource(String ... packages) {
        for (String pack : packages) {
            Hibernates.createRepositoryResource(Beans.getClasses((String)pack).toArray(new Class[0]));
        }
    }

    public static void createRepositoryResource(Class<?> ... models) {
        for (Class<?> model : models) {
            File repositoryImplement;
            File repositoryImplementPath;
            String repositoryInterfaceName;
            File repositoryInterface;
            File resourcePath;
            if (Beans.isMetaClass(model) || Modifier.isAbstract(model.getModifiers())) continue;
            try {
                resourcePath = new File(new File(URLDecoder.decode(System.getProperty("user.dir"), "utf-8")), "src");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String pack = model.getPackage().getName();
            String basePack = pack.substring(0, pack.lastIndexOf("."));
            File repositoryInterfacePath = new File(new File(resourcePath, Strings.replace((CharSequence)basePack, (char)'.', (char)'/')), "repository");
            if (!repositoryInterfacePath.exists()) {
                repositoryInterfacePath.mkdirs();
            }
            if (!(repositoryInterface = new File(repositoryInterfacePath, (repositoryInterfaceName = model.getSimpleName() + "Repository") + ".java")).exists()) {
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(repositoryInterface), "utf-8"));
                    writer.write("package " + basePack + ".repository;");
                    writer.newLine();
                    writer.newLine();
                    writer.write("import ars.database.repository.Repository;");
                    writer.newLine();
                    writer.newLine();
                    writer.write("import " + model.getName() + ";");
                    writer.newLine();
                    writer.newLine();
                    writer.write("/**");
                    writer.newLine();
                    writer.write(" * " + model.getSimpleName() + " repository interface");
                    writer.newLine();
                    writer.write(" *");
                    writer.newLine();
                    writer.write(" * @author " + System.getenv().get("USERNAME"));
                    writer.newLine();
                    writer.write(" *");
                    writer.newLine();
                    writer.write(" */");
                    writer.newLine();
                    writer.write("public interface " + repositoryInterfaceName + " extends Repository<" + model.getSimpleName() + "> {");
                    writer.newLine();
                    writer.newLine();
                    writer.write("}");
                    writer.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (!(repositoryImplementPath = new File(repositoryInterfacePath, "impl")).exists()) {
                repositoryImplementPath.mkdirs();
            }
            if ((repositoryImplement = new File(repositoryImplementPath, repositoryInterfaceName + "Impl.java")).exists()) continue;
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(repositoryImplement), "utf-8"));
                writer.write("package " + basePack + ".repository.impl;");
                writer.newLine();
                writer.newLine();
                writer.write("import org.springframework.stereotype.Repository;");
                writer.newLine();
                writer.newLine();
                writer.write("import ars.database.hibernate.HibernateSimpleRepository;");
                writer.newLine();
                writer.newLine();
                writer.write("import " + model.getName() + ";");
                writer.newLine();
                writer.write("import " + basePack + ".repository." + repositoryInterfaceName + ";");
                writer.newLine();
                writer.newLine();
                writer.write("@Repository");
                writer.newLine();
                writer.write("public class " + repositoryInterfaceName + "Impl extends HibernateSimpleRepository<" + model.getSimpleName() + "> implements " + repositoryInterfaceName + " {");
                writer.newLine();
                writer.newLine();
                writer.write("}");
                writer.newLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void createEntityConfigure(String ... packages) {
        for (String pack : packages) {
            Hibernates.createEntityConfigure(Beans.getClasses((String)pack).toArray(new Class[0]));
        }
    }

    public static void createEntityConfigure(Class<?> ... models) {
        for (Class<?> model : models) {
            File configure;
            File resourcePath;
            if (Beans.isMetaClass(model) || Modifier.isAbstract(model.getModifiers())) continue;
            try {
                resourcePath = new File(new File(URLDecoder.decode(System.getProperty("user.dir"), "utf-8")), "src");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String pack = model.getPackage().getName();
            File configurePath = new File(new File(resourcePath, Strings.replace((CharSequence)pack, (char)'.', (char)'/')), "hbm");
            if (!configurePath.exists()) {
                configurePath.mkdirs();
            }
            if ((configure = new File(configurePath, model.getSimpleName() + ".hbm.xml")).exists()) continue;
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configure), "utf-8"));
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.newLine();
                writer.write("<!DOCTYPE hibernate-mapping PUBLIC");
                writer.newLine();
                writer.write("\t\"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"");
                writer.newLine();
                writer.write("\t\"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\">");
                writer.newLine();
                writer.write("<hibernate-mapping>");
                writer.newLine();
                writer.write("\t<class name=\"" + model.getName() + "\" table=\"" + Strings.splitHumpString((String)model.getSimpleName(), (boolean)true) + "\">");
                writer.newLine();
                writer.write("\t\t<id name=\"id\" column=\"ID_\" type=\"int\">");
                writer.newLine();
                writer.write("\t\t\t<generator class=\"native\"/>");
                writer.newLine();
                writer.write("\t\t</id>");
                for (Class<?> _model = model; _model != Object.class; _model = _model.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = _model.getDeclaredFields()) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        String name = field.getName();
                        Class<?> type = field.getType();
                        if (type == Object.class || name.equals("id")) continue;
                        String column = Strings.splitHumpString((String)name, (boolean)true);
                        if (type == Byte.TYPE || type == Byte.class) {
                            writer.newLine();
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"byte\"/>");
                            continue;
                        }
                        if (type == byte[].class || type == Byte[].class) {
                            writer.newLine();
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"binary\"/>");
                            continue;
                        }
                        if (type == Integer.TYPE || type == Integer.class) {
                            writer.newLine();
                            if (Model.class.isAssignableFrom(model) && name.equals("status") || TreeModel.class.isAssignableFrom(model) && name.equals("level")) {
                                writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"int\" not-null=\"true\"/>");
                                continue;
                            }
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"int\"/>");
                            continue;
                        }
                        if (type == Short.TYPE || type == Short.class) {
                            writer.newLine();
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"short\"/>");
                            continue;
                        }
                        if (type == Float.TYPE || type == Float.class) {
                            writer.newLine();
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"float\"/>");
                            continue;
                        }
                        if (type == Double.TYPE || type == Double.class) {
                            writer.newLine();
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"double\"/>");
                            continue;
                        }
                        if (type == Long.TYPE || type == Long.class) {
                            writer.newLine();
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"long\"/>");
                            continue;
                        }
                        if (type == Boolean.TYPE || type == Boolean.class) {
                            writer.newLine();
                            if (Model.class.isAssignableFrom(model) && name.equals("active") || TreeModel.class.isAssignableFrom(model) && name.equals("leaf")) {
                                writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"boolean\" not-null=\"true\"/>");
                                continue;
                            }
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"boolean\"/>");
                            continue;
                        }
                        if (type == Character.TYPE || type == Character.class) {
                            writer.newLine();
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"character\"/>");
                            continue;
                        }
                        if (type == String.class) {
                            writer.newLine();
                            if (TreeModel.class.isAssignableFrom(model) && name.equals("key")) {
                                writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"string\" length=\"50\" not-null=\"true\" unique=\"true\"/>");
                                continue;
                            }
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"string\" length=\"50\"/>");
                            continue;
                        }
                        if (Date.class.isAssignableFrom(type)) {
                            writer.newLine();
                            if (Model.class.isAssignableFrom(model) && name.equals("dateJoined")) {
                                writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"timestamp\" not-null=\"true\"/>");
                                continue;
                            }
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\" type=\"timestamp\"/>");
                            continue;
                        }
                        if (Enum.class.isAssignableFrom(type)) {
                            writer.newLine();
                            writer.write("\t\t<property name=\"" + name + "\" column=\"" + column + "_\">");
                            writer.newLine();
                            writer.write("\t\t\t<type name=\"org.hibernate.type.EnumType\">");
                            writer.newLine();
                            writer.write("\t\t\t\t<param name=\"enumClass\">" + type.getName() + "</param>");
                            writer.newLine();
                            writer.write("\t\t\t</type>");
                            writer.newLine();
                            writer.write("\t\t</property>");
                            continue;
                        }
                        if (Collection.class.isAssignableFrom(type)) {
                            Class foreign = null;
                            Class[] genericTypes = Beans.getGenericTypes((Field)field);
                            if (genericTypes.length == 0 || (foreign = genericTypes[0]) == Object.class || Modifier.isAbstract(foreign.getModifiers())) continue;
                            writer.newLine();
                            if (Set.class.isAssignableFrom(type)) {
                                writer.write("\t\t<set name=\"" + name + "\">");
                            } else {
                                writer.write("\t\t<list name=\"" + name + "\">");
                            }
                            writer.newLine();
                            writer.write("\t\t\t<key column=\"" + Strings.splitHumpString((String)model.getSimpleName(), (boolean)true) + "_ID_\" not-null=\"true\"/>");
                            if (List.class.isAssignableFrom(type)) {
                                writer.newLine();
                                writer.write("\t\t\t<index column=\"ORDER_\"/>");
                            }
                            writer.newLine();
                            if (Beans.isMetaClass((Class)foreign)) {
                                writer.write("\t\t\t<element type=\"" + foreign.getName() + "\" column=\"" + name.toUpperCase() + "_\"/>");
                            } else {
                                writer.write("\t\t\t<many-to-many class=\"" + foreign.getName() + "\" column=\"" + Strings.splitHumpString((String)foreign.getSimpleName(), (boolean)true) + "_ID_\"/>");
                            }
                            writer.newLine();
                            if (Set.class.isAssignableFrom(type)) {
                                writer.write("\t\t</set>");
                                continue;
                            }
                            writer.write("\t\t</list>");
                            continue;
                        }
                        if (Modifier.isAbstract(type.getModifiers())) continue;
                        writer.newLine();
                        writer.write("\t\t<many-to-one name=\"" + name + "\" column=\"" + column + "_ID_\" class=\"" + type.getName() + "\"/>");
                    }
                }
                if (TreeModel.class.isAssignableFrom(model)) {
                    writer.newLine();
                    writer.write("\t\t<many-to-one name=\"parent\" column=\"PARENT_ID_\" class=\"" + model.getName() + "\"/>");
                    writer.newLine();
                    writer.write("\t\t<list name=\"children\" inverse=\"true\">");
                    writer.newLine();
                    writer.write("\t\t\t<key column=\"PARENT_ID_\"/>");
                    writer.newLine();
                    writer.write("\t\t\t<index column=\"ORDER_\"/>");
                    writer.newLine();
                    writer.write("\t\t\t<one-to-many class=\"" + model.getName() + "\"/>");
                    writer.newLine();
                    writer.write("\t\t</list>");
                }
                writer.newLine();
                writer.write("\t</class>");
                writer.newLine();
                writer.write("</hibernate-mapping>");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

