/*
 * Decompiled with CFR 0.152.
 */
package ars.database.service;

import ars.database.service.ExcelAdapter;
import ars.database.service.Service;
import ars.file.office.Excels;
import ars.invoke.Invokes;
import ars.invoke.request.Requester;
import ars.server.task.AbstractTaskServer;
import ars.util.Beans;
import ars.util.Dates;
import ars.util.Files;
import ars.util.Nfile;
import ars.util.Strings;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public final class Imexports {
    private static final File DIRECTORY = new File(Strings.TEMP_PATH, "imexport");
    private static final Pattern PATTERN = Pattern.compile("[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}.xlsx");

    private Imexports() {
    }

    public static <T> ExcelAdapter<T> getExcelAdapter(final Class<T> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        final Field[] fields = Beans.getFields(model, (String[])new String[0]);
        return new ExcelAdapter<T>(){

            @Override
            public String[] getTitles(Requester requester, Service<T> service) {
                return Invokes.getPropertyMessages((Requester)requester, (Class)model, (String[])new String[0]);
            }

            @Override
            public T read(Requester requester, Service<T> service, Row row, int count) {
                return Excels.getObject((Row)row, (Class)model, (Field[])fields);
            }

            @Override
            public void write(Requester requester, Service<T> service, T entity, Row row, int count) {
                Excels.setObject((Row)row, entity, (Field[])fields);
            }
        };
    }

    public static <T> Result input(Service<T> service, Requester requester, Nfile file, int start) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        return Imexports.input(service, requester, file, start, Imexports.getExcelAdapter(service.getModel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Result input(final Service<T> service, final Requester requester, Nfile file, int start, final ExcelAdapter<T> adapter) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        if (file == null) {
            throw new IllegalArgumentException("Illegal file:" + file);
        }
        if (start < 0) {
            throw new IllegalArgumentException("Illegal start:" + start);
        }
        if (adapter == null) {
            throw new IllegalArgumentException("Illegal adapter:" + adapter);
        }
        long timestamp = System.currentTimeMillis();
        final Result result = new Result();
        String[] titles = start > 0 ? Excels.getTitles((Nfile)file, (int)(start - 1)) : Strings.EMPTY_ARRAY;
        SXSSFWorkbook failed = new SXSSFWorkbook(100);
        try {
            int count = Excels.iteration((Nfile)file, (int)start, (Excels.Reader)new Excels.Reader<T>((Workbook)failed, titles, start){
                final /* synthetic */ Workbook val$failed;
                final /* synthetic */ String[] val$titles;
                final /* synthetic */ int val$start;
                {
                    this.val$failed = workbook;
                    this.val$titles = stringArray;
                    this.val$start = n;
                }

                public T read(Row row, int count) {
                    try {
                        Object entity = adapter.read(requester, service, row, count);
                        if (entity != null) {
                            service.saveObject(requester, entity);
                        }
                    }
                    catch (Exception e) {
                        Sheet sheet;
                        Row target = null;
                        if (result.getFailed() % 50000 == 0) {
                            sheet = this.val$failed.createSheet();
                            if (this.val$titles.length > 0) {
                                Excels.setTitles((Row)sheet.createRow(0), (String[])this.val$titles);
                            }
                            target = sheet.createRow(this.val$start);
                        } else {
                            sheet = this.val$failed.getSheetAt(this.val$failed.getNumberOfSheets() - 1);
                            target = sheet.createRow(sheet.getLastRowNum() + 1);
                        }
                        Excels.copy((Row)row, (Row)target);
                        int columns = this.val$titles.length > 0 ? this.val$titles.length : row.getLastCellNum();
                        Excels.setValue((Cell)target.createCell(columns), (Object)e.getMessage());
                        result.setFailed(result.getFailed() + 1);
                    }
                    return null;
                }
            });
            result.setTotal(count);
            if (result.getFailed() > 0) {
                String name = UUID.randomUUID().toString() + ".xlsx";
                File attachment = new File(DIRECTORY, name);
                Excels.write((Workbook)failed, (File)attachment);
                result.setFile(name);
                result.setSize(Files.getUnitSize((long)attachment.length()));
            }
        }
        finally {
            failed.close();
        }
        result.setSpend(Dates.getUnitTime((long)(System.currentTimeMillis() - timestamp)));
        return result;
    }

    public static <T> Result output(Service<T> service, Requester requester) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        return Imexports.output(service, requester, Imexports.getExcelAdapter(service.getModel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Result output(Service<T> service, Requester requester, ExcelAdapter<T> adapter) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        if (adapter == null) {
            throw new IllegalArgumentException("Illegal adapter:" + adapter);
        }
        Map parameters = requester.getParameters();
        Integer page = Beans.toInteger(Integer.class, parameters.remove("__page"));
        Integer size = Beans.toInteger(Integer.class, parameters.remove("__size"));
        long timestamp = System.currentTimeMillis();
        String[] titles = adapter.getTitles(requester, service);
        Result result = new Result();
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        try {
            Sheet sheet;
            if (page == null || size == null) {
                sheet = null;
                int r = 1;
                int count = 0;
                int length = 200;
                int total = service.getQuery(requester).custom(parameters).count();
                int pages = (int)Math.ceil((double)total / (double)length);
                for (int i = 1; i <= pages; ++i) {
                    List<T> objects = service.getQuery(requester).custom(parameters).paging(i, length).list();
                    for (int n = 0; n < objects.size(); ++n) {
                        if (++count % 50000 == 1) {
                            r = 1;
                            sheet = workbook.createSheet();
                            Excels.setTitles((Row)sheet.createRow(0), (String[])titles);
                        }
                        adapter.write(requester, service, objects.get(n), sheet.createRow(r++), count);
                    }
                }
                result.setTotal(count);
            } else {
                sheet = workbook.createSheet();
                Excels.setTitles((Row)sheet.createRow(0), (String[])titles);
                List<T> objects = service.getQuery(requester).custom(parameters).paging(page, size).list();
                for (int i = 0; i < objects.size(); ++i) {
                    adapter.write(requester, service, objects.get(i), sheet.createRow(i + 1), i + 1);
                }
                result.setTotal(objects.size());
            }
            String name = UUID.randomUUID().toString() + ".xlsx";
            File attachment = new File(DIRECTORY, name);
            Excels.write((Workbook)workbook, (File)attachment);
            result.setFile(name);
            result.setSize(Files.getUnitSize((long)attachment.length()));
            result.setSpend(Dates.getUnitTime((long)(System.currentTimeMillis() - timestamp)));
        }
        finally {
            workbook.close();
        }
        return result;
    }

    public static File download(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Illegal name:" + name);
        }
        File file = new File(DIRECTORY, name);
        return file.exists() ? file : null;
    }

    static {
        if (!DIRECTORY.exists()) {
            DIRECTORY.mkdirs();
        }
        AbstractTaskServer cleanupServer = new AbstractTaskServer(){

            protected void execute() throws Exception {
                DIRECTORY.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isFile() && PATTERN.matcher(file.getName()).matches() && System.currentTimeMillis() - file.lastModified() >= 86400000L) {
                            file.delete();
                        }
                        return false;
                    }
                });
            }
        };
        cleanupServer.setExpression("0 0 1 * * ?");
        cleanupServer.start();
    }

    public static class Result {
        private int total;
        private int failed;
        private String file;
        private String size;
        private String spend;

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public int getFailed() {
            return this.failed;
        }

        public void setFailed(int failed) {
            this.failed = failed;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getSpend() {
            return this.spend;
        }

        public void setSpend(String spend) {
            this.spend = spend;
        }
    }
}

