/*
 * Decompiled with CFR 0.152.
 */
package ars.database.service;

import ars.database.model.TreeModel;
import ars.database.service.Service;
import ars.database.service.ServiceFactory;
import ars.util.Beans;
import ars.util.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;

public final class Services {
    private static ServiceFactory serviceFactory;

    private Services() {
    }

    public static ServiceFactory getServiceFactory() {
        if (serviceFactory == null) {
            throw new RuntimeException("Service factory has not been initialize");
        }
        return serviceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setServiceFactory(ServiceFactory serviceFactory) {
        if (serviceFactory == null) {
            throw new IllegalArgumentException("Illegal serviceFactory:" + serviceFactory);
        }
        if (Services.serviceFactory != null) return;
        Class<Services> clazz = Services.class;
        synchronized (Services.class) {
            if (Services.serviceFactory != null) return;
            Services.serviceFactory = serviceFactory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static <M> Service<M> getService(Class<M> model) {
        return Services.getServiceFactory().getService(model);
    }

    public static void createServiceResource(String ... packages) {
        for (String pack : packages) {
            Services.createServiceResource(Beans.getClasses((String)pack).toArray(new Class[0]));
        }
    }

    public static void createServiceResource(Class<?> ... models) {
        for (Class<?> model : models) {
            File serviceImplement;
            File serviceImplementPath;
            String serviceInterfaceName;
            File serviceInterface;
            File resourcePath;
            if (Beans.isMetaClass(model) || Modifier.isAbstract(model.getModifiers())) continue;
            try {
                resourcePath = new File(new File(URLDecoder.decode(System.getProperty("user.dir"), "utf-8")), "src");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String pack = model.getPackage().getName();
            String basePack = pack.substring(0, pack.lastIndexOf("."));
            File serviceInterfacePath = new File(new File(resourcePath, Strings.replace((CharSequence)basePack, (char)'.', (char)'/')), "service");
            if (!serviceInterfacePath.exists()) {
                serviceInterfacePath.mkdirs();
            }
            if (!(serviceInterface = new File(serviceInterfacePath, (serviceInterfaceName = model.getSimpleName() + "Service") + ".java")).exists()) {
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serviceInterface), "utf-8"));
                    writer.write("package " + basePack + ".service;");
                    writer.newLine();
                    writer.newLine();
                    writer.write("import ars.invoke.local.Api;");
                    writer.newLine();
                    if (TreeModel.class.isAssignableFrom(model)) {
                        writer.write("import ars.database.service.TreeService;");
                        writer.newLine();
                    }
                    writer.write("import ars.database.service.BasicService;");
                    writer.newLine();
                    writer.newLine();
                    writer.write("import " + model.getName() + ";");
                    writer.newLine();
                    writer.newLine();
                    writer.write("/**");
                    writer.newLine();
                    writer.write(" * " + model.getSimpleName() + " service interface");
                    writer.newLine();
                    writer.write(" *");
                    writer.newLine();
                    writer.write(" * @author " + System.getenv().get("USERNAME"));
                    writer.newLine();
                    writer.write(" *");
                    writer.newLine();
                    writer.write(" */");
                    writer.newLine();
                    writer.write("@Api(\"" + (Strings.replace((CharSequence)pack.substring(0, pack.lastIndexOf(46)), (char)'.', (char)'/') + "/" + model.getSimpleName()).toLowerCase() + "\")");
                    writer.newLine();
                    if (TreeModel.class.isAssignableFrom(model)) {
                        writer.write("public interface " + serviceInterfaceName + " extends BasicService<" + model.getSimpleName() + ">, TreeService<" + model.getSimpleName() + "> {");
                    } else {
                        writer.write("public interface " + serviceInterfaceName + " extends BasicService<" + model.getSimpleName() + "> {");
                    }
                    writer.newLine();
                    writer.newLine();
                    writer.write("}");
                    writer.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (!(serviceImplementPath = new File(serviceInterfacePath, "impl")).exists()) {
                serviceImplementPath.mkdirs();
            }
            if ((serviceImplement = new File(serviceImplementPath, serviceInterfaceName + "Impl.java")).exists()) continue;
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serviceImplement), "utf-8"));
                writer.write("package " + basePack + ".service.impl;");
                writer.newLine();
                writer.newLine();
                writer.write("import org.springframework.stereotype.Service;");
                writer.newLine();
                writer.newLine();
                writer.write("import ars.database.service.StandardGeneralService;");
                writer.newLine();
                writer.newLine();
                writer.write("import " + model.getName() + ";");
                writer.newLine();
                writer.write("import " + basePack + ".service." + serviceInterfaceName + ";");
                writer.newLine();
                writer.newLine();
                writer.write("@Service");
                writer.newLine();
                writer.write("public class " + serviceInterfaceName + "Impl extends StandardGeneralService<" + model.getSimpleName() + "> implements " + serviceInterfaceName + " {");
                writer.newLine();
                writer.newLine();
                writer.write("}");
                writer.newLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

