/*
 * Decompiled with CFR 0.152.
 */
package ars.database.service;

import ars.database.model.TreeModel;
import ars.database.repository.Query;
import ars.database.repository.Repositories;
import ars.database.repository.Repository;
import ars.database.service.AbstractService;
import ars.invoke.request.Requester;
import ars.util.Beans;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class StandardGeneralService<T>
extends AbstractService<T> {
    private static final String EMPTY_PARAM_SUFFIX = "__" + "empty";
    private static final String NONEMPTY_PARAM_SUFFIX = "__" + "nempty";

    public Serializable add(Requester requester, Map<String, Object> parameters) {
        Object entity = Beans.getInstance(this.getModel());
        this.initObject(requester, entity, parameters);
        return this.saveObject(requester, entity);
    }

    public void delete(Requester requester, Map<String, Object> parameters) {
        boolean effective = false;
        Query query = this.getQuery(requester);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Beans.isEmpty((Object)value) && !(key = key.toLowerCase()).endsWith(EMPTY_PARAM_SUFFIX) && !key.endsWith(NONEMPTY_PARAM_SUFFIX)) continue;
            query.custom(entry.getKey(), value);
            effective = true;
        }
        if (effective) {
            List entities = query.list();
            for (int i = 0; i < entities.size(); ++i) {
                this.deleteObject(requester, entities.get(i));
            }
        }
    }

    public void update(Requester requester, Map<String, Object> parameters) {
        Repository<TreeModel> repository = this.getRepository();
        String primary = repository.getPrimary();
        Object[] identifiers = Beans.toArray(Object.class, (Object)parameters.get(primary));
        if (identifiers.length > 0) {
            List entities = this.getQuery(requester).or(primary, identifiers).list();
            for (int i = 0; i < entities.size(); ++i) {
                Object entity = entities.get(i);
                Boolean active = entity instanceof TreeModel ? ((TreeModel)entity).getActive() : null;
                this.initObject(requester, entity, parameters);
                this.updateObject(requester, entity);
                if (active == null || active == ((TreeModel)entity).getActive()) continue;
                TreeModel tree = (TreeModel)entity;
                if (tree.getActive() == Boolean.TRUE) {
                    for (TreeModel parent = (TreeModel)tree.getParent(); parent != null; parent = (TreeModel)parent.getParent()) {
                        if (parent.getActive() == Boolean.TRUE) continue;
                        parent.setActive(true);
                        repository.update(parent);
                    }
                    continue;
                }
                if (tree.getActive() != Boolean.FALSE) continue;
                List children = repository.query().ne(primary, tree.getId()).eq("active", true).start("key", tree.getKey()).list();
                for (int j = 0; j < children.size(); ++j) {
                    TreeModel child = (TreeModel)children.get(j);
                    if (child.getActive() == Boolean.FALSE) continue;
                    child.setActive(false);
                    repository.update(child);
                }
            }
        }
    }

    public int count(Requester requester, Map<String, Object> parameters) {
        Query query = this.getQuery(requester);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey().toLowerCase();
            if (key.equals("__page") || key.equals("__size")) continue;
            query.custom(entry.getKey(), entry.getValue());
        }
        return query.count();
    }

    public List<?> stats(Requester requester, Map<String, Object> parameters) {
        return this.getQuery(requester).custom(parameters).stats();
    }

    public T object(Requester requester, Map<String, Object> parameters) {
        boolean effective = false;
        Query query = this.getQuery(requester);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Beans.isEmpty((Object)value) && !(key = key.toLowerCase()).endsWith(EMPTY_PARAM_SUFFIX) && !key.endsWith(NONEMPTY_PARAM_SUFFIX)) continue;
            query.custom(entry.getKey(), value);
            effective = true;
        }
        return effective ? (T)query.single() : null;
    }

    public List<T> objects(Requester requester, Map<String, Object> parameters) {
        return this.getQuery(requester).custom(parameters).list();
    }

    public List<T> trees(Requester requester, Map<String, Object> parameters) {
        List objects = this.getQuery(requester).custom(parameters).list();
        return Repositories.mergeTrees(objects);
    }
}

