/*
 * Decompiled with CFR 0.152.
 */
package ars.database.service;

import ars.database.activiti.ActivityNode;
import ars.database.activiti.ProcessConfiguration;
import ars.database.model.Model;
import ars.database.repository.Query;
import ars.database.repository.Repositories;
import ars.database.service.Service;
import ars.invoke.request.Requester;
import ars.util.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.ProcessDiagramGenerator;

public final class Workflows {
    private static ProcessEngine engine;

    private Workflows() {
    }

    public static ProcessEngine getEngine() {
        if (engine == null) {
            throw new RuntimeException("Process engine has not been initialize");
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setEngine(ProcessEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Illegal engine:" + engine);
        }
        if (Workflows.engine != null) return;
        Class<Workflows> clazz = Workflows.class;
        synchronized (Workflows.class) {
            if (Workflows.engine != null) return;
            Workflows.engine = engine;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static ProcessConfiguration getConfiguration() {
        return (ProcessConfiguration)Workflows.getEngine().getProcessEngineConfiguration();
    }

    public static List<ActivityNode> getActivityNodes(Class<?> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        return Workflows.getConfiguration().getNodes(model);
    }

    public static <T extends Model> ProcessInstance getProcess(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Illegal id:" + id);
        }
        return (ProcessInstance)Workflows.getEngine().getRuntimeService().createProcessInstanceQuery().processInstanceId(id).singleResult();
    }

    public static <T extends Model> Task getTask(String process, String assignee) {
        if (process == null) {
            throw new IllegalArgumentException("Illegal process:" + process);
        }
        if (assignee == null) {
            throw new IllegalArgumentException("Illegal assignee:" + assignee);
        }
        return (Task)((TaskQuery)((TaskQuery)Workflows.getEngine().getTaskService().createTaskQuery().taskCandidateUser(assignee)).processInstanceId(process)).singleResult();
    }

    public static <T extends Model> ProcessInstance startProcess(Service<T> service, Requester requester, T entity, Map<String, Object> parameters) {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        if (entity == null) {
            throw new IllegalArgumentException("Illegal entity:" + entity);
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Illegal parameters:" + parameters);
        }
        if (entity.getProcess() != null) {
            throw new RuntimeException("Process is already started:" + entity);
        }
        RuntimeService runtimeService = Workflows.getEngine().getRuntimeService();
        ProcessConfiguration configuration = Workflows.getConfiguration();
        ProcessInstance process = runtimeService.startProcessInstanceByKey(configuration.getKey(service.getModel()), parameters);
        List<ActivityNode> nodes = configuration.getNodes(service.getModel());
        entity.setActive(false);
        entity.setProcess(process.getId());
        if (nodes.size() > 1) {
            entity.setStatus(nodes.get(1).getId());
        }
        service.updateObject(requester, entity);
        return process;
    }

    public static <T extends Model> void startProcess(Service<T> service, Requester requester, Map<String, Object> parameters) {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Illegal parameters:" + parameters);
        }
        String primary = service.getRepository().getPrimary();
        Object[] identifiers = Beans.toArray(Object.class, (Object)parameters.get(primary));
        if (identifiers.length > 0) {
            List<T> objects = service.getQuery(requester).or(primary, identifiers).list();
            for (int i = 0; i < objects.size(); ++i) {
                Workflows.startProcess(service, requester, (Model)objects.get(i), parameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Model> Task completeTask(Service<T> service, Requester requester, T entity, String assignee, Map<String, Object> parameters) {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        if (entity == null) {
            throw new IllegalArgumentException("Illegal entity:" + entity);
        }
        if (assignee == null) {
            throw new IllegalArgumentException("Illegal assignee:" + assignee);
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Illegal parameters:" + parameters);
        }
        Task task = Workflows.getTask(entity.getProcess(), assignee);
        if (task == null) {
            throw new RuntimeException("Task is already processed:" + entity);
        }
        TaskService taskService = Workflows.getEngine().getTaskService();
        taskService.claim(task.getId(), assignee);
        ProcessConfiguration configuration = Workflows.getConfiguration();
        ActivityNode node = configuration.getNode(service.getModel(), entity.getStatus());
        if (node == null) {
            throw new RuntimeException("Activity node does not exist with id:" + entity.getStatus());
        }
        taskService.complete(task.getId(), parameters);
        String string = entity.getProcess().intern();
        synchronized (string) {
            if (Workflows.getProcess(entity.getProcess()) == null) {
                entity.setActive(true);
                List<ActivityNode> nodes = configuration.getNodes(service.getModel());
                if (!nodes.isEmpty()) {
                    entity.setStatus(nodes.get(nodes.size() - 1).getId());
                }
                service.updateObject(requester, entity);
            } else {
                List activities = Workflows.getEngine().getRuntimeService().getActiveActivityIds(entity.getProcess());
                if (activities.isEmpty() || !((String)activities.get(0)).equals(node.getCode())) {
                    String activity = (String)activities.get(0);
                    ActivityNode next = configuration.getNode(service.getModel(), activity);
                    if (next == null) {
                        throw new RuntimeException("Activity node does not exist with code:" + activity);
                    }
                    entity.setStatus(next.getId());
                    service.updateObject(requester, entity);
                }
            }
        }
        return task;
    }

    public static <T extends Model> void completeTask(Service<T> service, Requester requester, Map<String, Object> parameters) {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Illegal parameters:" + parameters);
        }
        String primary = service.getRepository().getPrimary();
        Object[] identifiers = Beans.toArray(Object.class, (Object)parameters.get(primary));
        if (identifiers.length > 0) {
            List<T> objects = service.getQuery(requester).or(primary, identifiers).list();
            for (int i = 0; i < objects.size(); ++i) {
                Workflows.completeTask(service, requester, (Model)objects.get(i), requester.getUser(), parameters);
            }
        }
    }

    public static <T extends Model> Query<T> getTaskQuery(Service<T> service, Requester requester, String assignee, Map<String, Object> parameters) {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        if (assignee == null) {
            throw new IllegalArgumentException("Illegal assignee:" + assignee);
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Illegal parameters:" + parameters);
        }
        List tasks = ((TaskQuery)Workflows.getEngine().getTaskService().createTaskQuery().taskCandidateUser(assignee)).list();
        if (tasks.isEmpty()) {
            return Repositories.emptyQuery();
        }
        Object[] processes = new String[tasks.size()];
        for (int i = 0; i < tasks.size(); ++i) {
            processes[i] = ((Task)tasks.get(i)).getProcessInstanceId();
        }
        return service.getQuery(requester).in("process", processes).custom(parameters);
    }

    public static <T extends Model> Query<T> getFinishQuery(Service<T> service, Requester requester, String assignee, Map<String, Object> parameters) {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        if (assignee == null) {
            throw new IllegalArgumentException("Illegal assignee:" + assignee);
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Illegal parameters:" + parameters);
        }
        HistoryService historyService = Workflows.getEngine().getHistoryService();
        List historicTaskInstances = ((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().taskAssignee(assignee)).list();
        if (historicTaskInstances.isEmpty()) {
            return Repositories.emptyQuery();
        }
        Object[] processes = new String[historicTaskInstances.size()];
        for (int i = 0; i < historicTaskInstances.size(); ++i) {
            processes[i] = ((HistoricTaskInstance)historicTaskInstances.get(i)).getProcessInstanceId();
        }
        return service.getQuery(requester).in("process", processes).custom(parameters);
    }

    public static <T extends Model> int getWorkload(Service<T> service, Requester requester, Map<String, Object> parameters) {
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        return Workflows.getTaskQuery(service, requester, requester.getUser(), parameters).count();
    }

    public static <T extends Model> List<T> getTasks(Service<T> service, Requester requester, Map<String, Object> parameters) {
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        return Workflows.getTaskQuery(service, requester, requester.getUser(), parameters).list();
    }

    public static <T extends Model> int getProgress(Service<T> service, Requester requester, Map<String, Object> parameters) {
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        return Workflows.getFinishQuery(service, requester, requester.getUser(), parameters).count();
    }

    public static <T extends Model> List<T> getHistories(Service<T> service, Requester requester, Map<String, Object> parameters) {
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        return Workflows.getFinishQuery(service, requester, requester.getUser(), parameters).list();
    }

    public static <T extends Model> InputStream getDiagram(Service<T> service, Requester requester, Map<String, Object> parameters) throws IOException {
        if (service == null) {
            throw new IllegalArgumentException("Illegal service:" + service);
        }
        if (requester == null) {
            throw new IllegalArgumentException("Illegal requester:" + requester);
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Illegal parameters:" + parameters);
        }
        Model entity = (Model)service.getQuery(requester).custom(parameters).single();
        List<ActivityNode> nodes = Workflows.getActivityNodes(service.getModel());
        ProcessEngineConfiguration configuration = Workflows.getEngine().getProcessEngineConfiguration();
        ProcessDiagramGenerator diagramGenerator = configuration.getProcessDiagramGenerator();
        RepositoryService repositoryService = Workflows.getEngine().getRepositoryService();
        String identifier = ((ProcessConfiguration)configuration).getIdentifier(service.getModel());
        List<String> activities = entity == null ? Arrays.asList(nodes.get(0).getCode()) : (entity.getStatus().equals(nodes.get(nodes.size() - 1).getId()) ? Arrays.asList(nodes.get(nodes.size() - 1).getCode()) : Workflows.getEngine().getRuntimeService().getActiveActivityIds(entity.getProcess()));
        return diagramGenerator.generateDiagram(repositoryService.getBpmnModel(identifier), "png", activities, Collections.emptyList(), configuration.getActivityFontName(), configuration.getLabelFontName(), configuration.getClassLoader(), 1.0);
    }
}

