/*
 * Decompiled with CFR 0.152.
 */
package ars.database.spring;

import ars.invoke.event.InvokeBeforeEvent;
import ars.invoke.event.InvokeCompleteEvent;
import ars.invoke.event.InvokeEvent;
import ars.invoke.event.InvokeListener;
import ars.util.Strings;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DataSourceRouter
extends AbstractRoutingDataSource
implements InvokeListener<InvokeEvent> {
    private Map<String, String> routes = new HashMap<String, String>();
    private final ThreadLocal<String> dataSource = new ThreadLocal();

    public Map<String, String> getRoutes() {
        return this.routes;
    }

    public void setRoutes(Map<String, String> routes) {
        this.routes = routes;
    }

    protected Object determineCurrentLookupKey() {
        return this.dataSource.get();
    }

    public void onInvokeEvent(InvokeEvent event) {
        if (event instanceof InvokeBeforeEvent) {
            String uri = event.getSource().getUri();
            for (Map.Entry<String, String> entry : this.routes.entrySet()) {
                if (!Strings.matches((String)uri, (String)entry.getKey())) continue;
                this.dataSource.set(entry.getValue());
                break;
            }
        } else if (event instanceof InvokeCompleteEvent) {
            this.dataSource.remove();
        }
    }
}

