/*
 * Decompiled with CFR 0.152.
 */
package ars.database.spring;

import ars.database.repository.DataConstraintException;
import ars.database.repository.Repositories;
import ars.database.repository.Repository;
import ars.database.repository.RepositoryFactory;
import ars.database.service.Service;
import ars.database.service.ServiceFactory;
import ars.database.service.Services;
import ars.database.service.WorkflowService;
import ars.database.service.event.ServiceEvent;
import ars.database.service.event.ServiceListener;
import ars.invoke.convert.ThrowableResolver;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DatabaseConfiguration
implements ThrowableResolver,
ServiceFactory,
RepositoryFactory,
ApplicationContextAware {
    public static final int CODE_ERROR_DATA_CONSTRAINT = 52070;
    private Map<Class<?>, Service<?>> services = Collections.emptyMap();
    private Map<Class<?>, Repository<?>> repositories = Collections.emptyMap();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Services.setServiceFactory(this);
        Repositories.setRepositoryFactory(this);
        Collection repositories = applicationContext.getBeansOfType(Repository.class).values();
        this.repositories = new HashMap(repositories.size());
        for (Object repository : repositories) {
            this.repositories.put(repository.getModel(), (Repository<?>)repository);
        }
        Collection services = applicationContext.getBeansOfType(Service.class).values();
        this.services = new HashMap(services.size());
        for (Object service : services) {
            if (service instanceof WorkflowService) {
                ((WorkflowService)service).setProcessEngine((ProcessEngine)applicationContext.getBean(ProcessEngine.class));
            }
            this.services.put(service.getModel(), (Service<?>)service);
        }
        HashMap listeners = new HashMap();
        try {
            for (Map.Entry entry : applicationContext.getBeansOfType(ServiceListener.class).entrySet()) {
                ServiceListener target = null;
                ServiceListener listener = (ServiceListener)entry.getValue();
                if (AopUtils.isAopProxy((Object)listener)) {
                    target = (ServiceListener)((Advised)listener).getTargetSource().getTarget();
                }
                Class<?> type = null;
                for (Method method : (target == null ? listener : target).getClass().getMethods()) {
                    if (!method.getName().equals("onServiceEvent") || type != null && type != ServiceEvent.class) continue;
                    type = method.getParameterTypes()[0];
                }
                LinkedList<ServiceListener> groups = (LinkedList<ServiceListener>)listeners.get(type);
                if (groups == null) {
                    groups = new LinkedList<ServiceListener>();
                    listeners.put(type, groups);
                }
                groups.add(listener);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!listeners.isEmpty()) {
            for (Map.Entry entry : listeners.entrySet()) {
                Class type = (Class)entry.getKey();
                ServiceListener[] _listeners = ((List)entry.getValue()).toArray(new ServiceListener[0]);
                for (Service service : services) {
                    service.setListeners(type, _listeners);
                }
            }
        }
    }

    public int getCode(Throwable throwable) {
        return 52070;
    }

    public String getMessage(Throwable throwable) {
        return throwable.getMessage();
    }

    public boolean isResolvable(Throwable throwable) {
        return throwable != null && throwable instanceof DataConstraintException;
    }

    @Override
    public Map<Class<?>, Service<?>> getServices() {
        return Collections.unmodifiableMap(this.services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Service<T> getService(Class<T> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        Service<?> service = this.services.get(model);
        if (service == null) {
            Class<T> clazz = model;
            synchronized (clazz) {
                service = this.services.get(model);
                if (service == null) {
                    for (Map.Entry<Class<?>, Service<?>> entry : this.services.entrySet()) {
                        if (!entry.getKey().isAssignableFrom(model)) continue;
                        service = entry.getValue();
                        this.services.put(model, service);
                    }
                }
            }
        }
        if (service == null) {
            throw new RuntimeException("Service not found:" + model);
        }
        return service;
    }

    @Override
    public Map<Class<?>, Repository<?>> getRepositories() {
        return Collections.unmodifiableMap(this.repositories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Repository<T> getRepository(Class<T> model) {
        if (model == null) {
            throw new IllegalArgumentException("Illegal model:" + model);
        }
        Repository<?> repository = this.repositories.get(model);
        if (repository == null) {
            Class<T> clazz = model;
            synchronized (clazz) {
                repository = this.repositories.get(model);
                if (repository == null) {
                    for (Map.Entry<Class<?>, Repository<?>> entry : this.repositories.entrySet()) {
                        if (!entry.getKey().isAssignableFrom(model)) continue;
                        repository = entry.getValue();
                        this.repositories.put(model, repository);
                    }
                }
            }
        }
        if (repository == null) {
            throw new RuntimeException("Repository not found:" + model);
        }
        return repository;
    }
}

