/*
 * Decompiled with CFR 0.152.
 */
package ars.database.spring;

import ars.database.model.TreeModel;
import ars.database.repository.Repositories;
import ars.database.repository.Repository;
import ars.spring.context.ApplicationInitializer;
import ars.util.Beans;
import ars.util.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.event.ContextRefreshedEvent;

public class EntitySynchronUpgrader<T>
extends ApplicationInitializer {
    private Comparator<T> comparator;
    private List<T> entities = Collections.emptyList();
    private String[] comparators = Strings.EMPTY_ARRAY;
    private List<String> includes = new LinkedList<String>();

    public List<T> getEntities() {
        return this.entities;
    }

    public void setEntities(List<T> entities) {
        this.entities = entities;
    }

    public String[] getComparators() {
        return this.comparators;
    }

    public void setComparators(String ... comparators) {
        this.comparators = comparators;
    }

    protected void synchron(Collection<T> sources, Collection<T> targets) {
        block0: for (T target : targets) {
            for (T source : sources) {
                List children;
                if (this.comparator.compare(source, target) != 0) continue;
                if (source instanceof TreeModel && !(children = ((TreeModel)target).getChildren()).isEmpty()) {
                    for (Object child : children) {
                        ((TreeModel)child).setParent((TreeModel)source);
                    }
                    this.synchron(((TreeModel)source).getChildren(), children);
                }
                if (this.includes.isEmpty()) continue block0;
                boolean different = false;
                for (String property : this.includes) {
                    Object targetValue;
                    Object sourceValue = Beans.getValue(source, (String)property);
                    if (Beans.isEqual((Object)sourceValue, (Object)(targetValue = Beans.getValue(target, (String)property)))) continue;
                    Beans.setValue(source, (String)property, (Object)targetValue);
                    different = true;
                }
                if (!different) continue block0;
                Repositories.update(source);
                continue block0;
            }
            if (target instanceof TreeModel) {
                Repositories.saveTree((TreeModel)target);
                continue;
            }
            Repositories.save(target);
        }
    }

    protected void execute(ContextRefreshedEvent event) {
        if (this.entities.isEmpty()) {
            throw new RuntimeException("Target entities has not been initialize");
        }
        Class<?> model = this.entities.get(0).getClass();
        Repository<?> repository = Repositories.getRepository(model);
        String primary = repository.getPrimary();
        LinkedList<String> excludes = new LinkedList<String>();
        final LinkedList<String> conditions = new LinkedList<String>();
        for (String property : this.comparators) {
            if (property.equals(primary)) continue;
            if (property.charAt(0) == '+') {
                this.includes.add(property.substring(1));
                continue;
            }
            if (property.charAt(0) == '-') {
                excludes.add(property.substring(1));
                continue;
            }
            conditions.add(property);
        }
        if (this.includes.isEmpty() && !excludes.isEmpty()) {
            for (String property : Beans.getProperties(model)) {
                if (property.equals(primary) || excludes.contains(property)) continue;
                this.includes.add(property);
            }
        }
        this.comparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (conditions.isEmpty()) {
                    return o1.equals(o2) ? 0 : -1;
                }
                for (String property : conditions) {
                    if (Beans.isEqual((Object)Beans.getValue(o1, (String)property), (Object)Beans.getValue(o2, (String)property))) continue;
                    return -1;
                }
                return 0;
            }
        };
        List<?> sources = repository.query().list();
        if (TreeModel.class.isAssignableFrom(model)) {
            sources = Repositories.mergeTrees(sources);
        }
        this.synchron(sources, this.entities);
    }
}

