/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker;

import org.apache.commons.codec.digest.DigestUtils;

public interface Digest {
    public String alg();

    public String hex();

    default public String string() {
        return String.format("%s:%s", this.alg(), this.hex());
    }

    public static final class FromString
    implements Digest {
        private final String original;

        public FromString(String original) {
            this.original = original;
        }

        @Override
        public String alg() {
            return this.part(0);
        }

        @Override
        public String hex() {
            return this.part(1);
        }

        public String toString() {
            return this.original;
        }

        public boolean valid() {
            return this.original.split(":").length == 2;
        }

        private String part(int pos) {
            if (!this.valid()) {
                throw new IllegalStateException(String.format("Expected two parts separated by `:`, but was `%s`", this.original));
            }
            return this.original.split(":")[pos];
        }
    }

    public static final class Sha256
    implements Digest {
        private final String hex;

        public Sha256(String hex) {
            this.hex = hex;
        }

        public Sha256(byte[] bytes) {
            this(DigestUtils.sha256Hex((byte[])bytes));
        }

        @Override
        public String alg() {
            return "sha256";
        }

        @Override
        public String hex() {
            return this.hex;
        }

        public String toString() {
            return this.string();
        }
    }
}

