/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker;

import com.artipie.docker.error.InvalidTagNameException;
import java.util.regex.Pattern;

public interface Tag {
    public String value();

    public static final class Valid
    implements Tag {
        private static final Pattern PATTERN = Pattern.compile("^[a-zA-Z0-9_][a-zA-Z0-9_.-]{0,127}$");
        private final String original;

        public Valid(String original) {
            this.original = original;
        }

        @Override
        public String value() {
            if (!this.valid()) {
                throw new InvalidTagNameException(String.format("Invalid tag: '%s'", this.original));
            }
            return this.original;
        }

        public boolean valid() {
            return PATTERN.matcher(this.original).matches();
        }
    }
}

