/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.docker.Catalog;
import com.artipie.docker.RepoName;
import com.artipie.docker.asto.Children;
import com.artipie.docker.misc.CatalogPage;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

final class AstoCatalog
implements Catalog {
    private final Key root;
    private final Collection<Key> keys;
    private final Optional<RepoName> from;
    private final int limit;

    AstoCatalog(Key root, Collection<Key> keys, Optional<RepoName> from, int limit) {
        this.root = root;
        this.keys = keys;
        this.from = from;
        this.limit = limit;
    }

    @Override
    public Content json() {
        return new CatalogPage(this.repos(), this.from, this.limit).json();
    }

    private Collection<RepoName> repos() {
        return new Children(this.root, this.keys).names().stream().map(RepoName.Simple::new).collect(Collectors.toList());
    }
}

