/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.FailedCompletionStage;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.Layers;
import com.artipie.docker.RepoName;
import com.artipie.docker.Upload;
import com.artipie.docker.asto.BlobSource;
import com.artipie.docker.asto.UploadsLayout;
import com.artipie.docker.error.InvalidDigestException;
import com.artipie.docker.misc.DigestedFlowable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

public final class AstoUpload
implements Upload {
    private final Storage storage;
    private final UploadsLayout layout;
    private final RepoName name;
    private final String uuid;

    public AstoUpload(Storage storage, UploadsLayout layout, RepoName name, String uuid) {
        this.storage = storage;
        this.layout = layout;
        this.name = name;
        this.uuid = uuid;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public CompletionStage<Void> start() {
        return this.storage.save(this.started(), (Content)new Content.From(new byte[0]));
    }

    @Override
    public CompletionStage<Long> append(Publisher<ByteBuffer> chunk) {
        return this.chunks().thenCompose(chunks -> {
            if (chunks.size() > 0) {
                throw new UnsupportedOperationException("Multiple chunks are not supported");
            }
            Key.From tmp = new Key.From(this.root(), new String[]{UUID.randomUUID().toString()});
            DigestedFlowable data = new DigestedFlowable(chunk);
            return ((CompletableFuture)this.storage.save((Key)tmp, (Content)new Content.From((Publisher)data)).thenCompose(arg_0 -> this.lambda$append$1(data, (Key)tmp, arg_0))).thenCompose(key -> this.storage.size(key).thenApply(updated -> updated - 1L));
        });
    }

    @Override
    public CompletionStage<Long> offset() {
        return this.chunks().thenCompose(chunks -> {
            CompletionStage<Long> result;
            if (chunks.isEmpty()) {
                result = CompletableFuture.completedFuture(0L);
            } else {
                Key key = (Key)chunks.iterator().next();
                result = this.storage.size(key).thenApply(size -> Math.max(size - 1L, 0L));
            }
            return result;
        });
    }

    @Override
    public CompletionStage<Blob> putTo(Layers layers, final Digest digest) {
        final Key source = this.chunk(digest);
        return this.storage.exists(source).thenCompose(exists -> {
            Object result = exists != false ? layers.put(new BlobSource(){

                @Override
                public Digest digest() {
                    return digest;
                }

                @Override
                public CompletionStage<Void> saveTo(Storage asto, Key key) {
                    return asto.move(source, key);
                }
            }).thenCompose(blob -> this.delete().thenApply(nothing -> blob)) : new FailedCompletionStage((Throwable)new InvalidDigestException(digest.toString()));
            return result;
        });
    }

    Key root() {
        return this.layout.upload(this.name, this.uuid);
    }

    private Key started() {
        return new Key.From(this.root(), new String[]{"started"});
    }

    private Key chunk(Digest digest) {
        return new Key.From(this.root(), new String[]{String.format("%s_%s", digest.alg(), digest.hex())});
    }

    private CompletableFuture<Collection<Key>> chunks() {
        return this.storage.list(this.root()).thenApply(keys -> keys.stream().filter(key -> !key.string().equals(this.started().string())).collect(Collectors.toList()));
    }

    private CompletionStage<Void> delete() {
        return this.storage.list(this.root()).thenCompose(list -> CompletableFuture.allOf((CompletableFuture[])list.stream().map(file -> this.storage.delete(file).toCompletableFuture()).toArray(CompletableFuture[]::new)));
    }

    private /* synthetic */ CompletionStage lambda$append$1(DigestedFlowable data, Key tmp, Void nothing) {
        Key key = this.chunk(data.digest());
        return this.storage.move(tmp, key).thenApply(ignored -> key);
    }
}

