/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Key;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

class Children {
    private final Key root;
    private final Collection<Key> keys;

    Children(Key root, Collection<Key> keys) {
        this.root = root;
        this.keys = keys;
    }

    public Set<String> names() {
        TreeSet<String> set = new TreeSet<String>();
        for (Key key : this.keys) {
            set.add(this.child(key));
        }
        return set;
    }

    private String child(Key key) {
        Key child = key;
        while (true) {
            Optional parent;
            if (!(parent = child.parent()).isPresent()) {
                throw new IllegalStateException(String.format("Key %s does not belong to root %s", key, this.root));
            }
            if (((Key)parent.get()).string().equals(this.root.string())) break;
            child = (Key)parent.get();
        }
        return child.string().substring(this.root.string().length() + 1);
    }
}

