/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.docker.Digest;
import com.artipie.docker.asto.BlobSource;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class TrustedBlobSource
implements BlobSource {
    private final Digest dig;
    private final Content content;

    public TrustedBlobSource(byte[] bytes) {
        this((Content)new Content.From(bytes), new Digest.Sha256(bytes));
    }

    public TrustedBlobSource(Content content, Digest dig) {
        this.dig = dig;
        this.content = content;
    }

    @Override
    public Digest digest() {
        return this.dig;
    }

    @Override
    public CompletionStage<Void> saveTo(Storage storage, Key key) {
        return storage.exists(key).thenCompose(exists -> {
            CompletableFuture result = exists != false ? CompletableFuture.allOf(new CompletableFuture[0]) : storage.save(key, this.content);
            return result;
        });
    }
}

