/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.docker.Catalog;
import com.artipie.docker.Docker;
import com.artipie.docker.Repo;
import com.artipie.docker.RepoName;
import com.artipie.docker.misc.CatalogPage;
import com.artipie.docker.misc.ParsedCatalog;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class TrimmedDocker
implements Docker {
    private final Docker origin;
    private final String prefix;

    public TrimmedDocker(Docker origin, String prefix) {
        this.origin = origin;
        this.prefix = prefix;
    }

    @Override
    public Repo repo(RepoName name) {
        return this.origin.repo(this.trim(name));
    }

    @Override
    public CompletionStage<Catalog> catalog(Optional<RepoName> from, int limit) {
        return this.origin.catalog(from.map(this::trim), limit).thenCompose(catalog -> new ParsedCatalog((Catalog)catalog).repos()).thenApply(names -> names.stream().map(name -> String.format("%s/%s", this.prefix, name.value())).map(RepoName.Valid::new).collect(Collectors.toList())).thenApply(names -> new CatalogPage((Collection<RepoName>)names, from, limit));
    }

    private RepoName trim(RepoName name) {
        Pattern pattern = Pattern.compile(String.format("(?:%s)\\/(.+)", this.prefix));
        Matcher matcher = pattern.matcher(name.value());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Invalid image name: name `%s` must start with `%s/`", name.value(), this.prefix));
        }
        return new RepoName.Valid(matcher.group(1));
    }
}

