/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.Docker;
import com.artipie.docker.Repo;
import com.artipie.docker.RepoName;
import com.artipie.docker.error.UploadUnknownError;
import com.artipie.docker.http.DigestHeader;
import com.artipie.docker.http.ErrorsResponse;
import com.artipie.docker.http.Scope;
import com.artipie.docker.http.ScopeSlice;
import com.artipie.docker.misc.RqByRegex;
import com.artipie.http.Connection;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.headers.Header;
import com.artipie.http.headers.Location;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqParams;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

public final class UploadEntity {
    public static final Pattern PATH = Pattern.compile("^/v2/(?<name>.*)/blobs/uploads/(?<uuid>[^/]*).*$");

    private UploadEntity() {
    }

    private static final class BlobCreatedResponse
    extends Response.Wrap {
        private BlobCreatedResponse(RepoName name, Digest digest) {
            super((Response)new RsWithHeaders((Response)new RsWithStatus(RsStatus.CREATED), new Map.Entry[]{new Location(String.format("/v2/%s/blobs/%s", name.value(), digest.string())), new ContentLength("0"), new DigestHeader(digest)}));
        }
    }

    private static class StatusResponse
    implements Response {
        private final RepoName name;
        private final String uuid;
        private final long offset;

        StatusResponse(RepoName name, String uuid, long offset) {
            this.name = name;
            this.uuid = uuid;
            this.offset = offset;
        }

        public CompletionStage<Void> send(Connection connection) {
            return new RsWithHeaders((Response)new RsWithStatus(RsStatus.ACCEPTED), new Map.Entry[]{new Location(String.format("/v2/%s/blobs/uploads/%s", this.name.value(), this.uuid)), new Header("Range", String.format("0-%d", this.offset)), new ContentLength("0"), new Header("Docker-Upload-UUID", this.uuid)}).send(connection);
        }
    }

    static final class Request {
        private final String line;

        Request(String line) {
            this.line = line;
        }

        RepoName name() {
            return new RepoName.Valid(new RqByRegex(this.line, PATH).path().group("name"));
        }

        String uuid() {
            return new RqByRegex(this.line, PATH).path().group("uuid");
        }

        Digest digest() {
            return this.params().value("digest").map(Digest.FromString::new).orElseThrow(() -> new IllegalStateException(String.format("Unexpected query: %s", this.line)));
        }

        Optional<Digest> mount() {
            return this.params().value("mount").map(Digest.FromString::new);
        }

        Optional<RepoName> from() {
            return this.params().value("from").map(RepoName.Valid::new);
        }

        private RqParams params() {
            return new RqParams(new RequestLineFrom(this.line).uri().getQuery());
        }
    }

    public static final class Get
    implements ScopeSlice {
        private final Docker docker;

        Get(Docker docker) {
            this.docker = docker;
        }

        @Override
        public Scope scope(String line) {
            return new Scope.Repository.Pull(new Request(line).name());
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            String uuid = request.uuid();
            return new AsyncResponse(this.docker.repo(name).uploads().get(uuid).thenApply(found -> found.map(upload -> new AsyncResponse(upload.offset().thenApply(offset -> new RsWithHeaders((Response)new RsWithStatus(RsStatus.NO_CONTENT), new Map.Entry[]{new ContentLength("0"), new Header("Range", String.format("0-%d", offset)), new Header("Docker-Upload-UUID", uuid)})))).orElseGet(() -> new ErrorsResponse(RsStatus.NOT_FOUND, new UploadUnknownError(uuid)))));
        }
    }

    public static final class Put
    implements ScopeSlice {
        private final Docker docker;

        Put(Docker docker) {
            this.docker = docker;
        }

        @Override
        public Scope scope(String line) {
            return new Scope.Repository.Push(new Request(line).name());
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            String uuid = request.uuid();
            Repo repo = this.docker.repo(name);
            return new AsyncResponse(repo.uploads().get(uuid).thenApply(found -> found.map(upload -> new AsyncResponse(upload.putTo(repo.layers(), request.digest()).thenApply(any -> new BlobCreatedResponse(name, request.digest())))).orElseGet(() -> new ErrorsResponse(RsStatus.NOT_FOUND, new UploadUnknownError(uuid)))));
        }
    }

    public static final class Patch
    implements ScopeSlice {
        private final Docker docker;

        Patch(Docker docker) {
            this.docker = docker;
        }

        @Override
        public Scope scope(String line) {
            return new Scope.Repository.Push(new Request(line).name());
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            String uuid = request.uuid();
            return new AsyncResponse(this.docker.repo(name).uploads().get(uuid).thenApply(found -> found.map(upload -> new AsyncResponse(upload.append(body).thenApply(offset -> new StatusResponse(name, uuid, (long)offset)))).orElseGet(() -> new ErrorsResponse(RsStatus.NOT_FOUND, new UploadUnknownError(uuid)))));
        }
    }

    public static final class Post
    implements ScopeSlice {
        private final Docker docker;

        Post(Docker docker) {
            this.docker = docker;
        }

        @Override
        public Scope scope(String line) {
            return new Scope.Repository.Push(new Request(line).name());
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName target = request.name();
            Optional<Digest> mount = request.mount();
            Optional<RepoName> from = request.from();
            Response response = mount.isPresent() && from.isPresent() ? this.mount(mount.get(), from.get(), target) : this.startUpload(target);
            return response;
        }

        private Response mount(Digest digest, RepoName source, RepoName target) {
            return new AsyncResponse(this.docker.repo(source).layers().get(digest).thenCompose(opt -> opt.map(src -> this.docker.repo(target).layers().mount((Blob)src).thenApply(blob -> new BlobCreatedResponse(target, blob.digest()))).orElseGet(() -> CompletableFuture.completedFuture(this.startUpload(target)))));
        }

        private Response startUpload(RepoName name) {
            return new AsyncResponse(this.docker.repo(name).uploads().start().thenApply(upload -> new StatusResponse(name, upload.uuid(), 0L)));
        }
    }
}

