/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.proxy;

import com.artipie.asto.Content;
import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.RepoName;
import com.artipie.docker.proxy.BlobPath;
import com.artipie.http.Headers;
import com.artipie.http.Slice;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqMethod;
import io.reactivex.Flowable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class ProxyBlob
implements Blob {
    private final Slice remote;
    private final RepoName name;
    private final Digest dig;
    private final long bsize;

    public ProxyBlob(Slice remote, RepoName name, Digest dig, long size) {
        this.remote = remote;
        this.name = name;
        this.dig = dig;
        this.bsize = size;
    }

    @Override
    public Digest digest() {
        return this.dig;
    }

    @Override
    public CompletionStage<Long> size() {
        return CompletableFuture.completedFuture(this.bsize);
    }

    @Override
    public CompletionStage<Content> content() {
        CompletableFuture<Content> result = new CompletableFuture<Content>();
        this.remote.response(new RequestLine(RqMethod.GET, new BlobPath(this.name, this.dig).string()).toString(), (Iterable)Headers.EMPTY, (Publisher)Flowable.empty()).send((status, headers, body) -> {
            CompletableFuture terminated = new CompletableFuture();
            result.complete((Content)new Content.From(new ContentLength(headers).longValue(), (Publisher)Flowable.fromPublisher((Publisher)body).doOnError(terminated::completeExceptionally).doOnTerminate(() -> terminated.complete(null))));
            return terminated;
        }).handle((nothing, throwable) -> {
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            }
            return nothing;
        });
        return result;
    }
}

