/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.proxy;

import com.artipie.asto.Content;
import com.artipie.asto.FailedCompletionStage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.docker.Digest;
import com.artipie.docker.Manifests;
import com.artipie.docker.RepoName;
import com.artipie.docker.Tag;
import com.artipie.docker.Tags;
import com.artipie.docker.http.DigestHeader;
import com.artipie.docker.manifest.JsonManifest;
import com.artipie.docker.manifest.Manifest;
import com.artipie.docker.proxy.ManifestPath;
import com.artipie.docker.proxy.ResponseSink;
import com.artipie.docker.proxy.TagsListUri;
import com.artipie.docker.ref.ManifestRef;
import com.artipie.http.Headers;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsStatus;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class ProxyManifests
implements Manifests {
    private final Slice remote;
    private final RepoName name;

    public ProxyManifests(Slice remote, RepoName name) {
        this.remote = remote;
        this.name = name;
    }

    @Override
    public CompletionStage<Manifest> put(ManifestRef ref, Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Optional<Manifest>> get(ManifestRef ref) {
        return new ResponseSink(this.remote.response(new RequestLine(RqMethod.GET, new ManifestPath(this.name, ref).string()).toString(), (Iterable)Headers.EMPTY, (Publisher)Content.EMPTY), (status, headers, body) -> {
            CompletionStage result;
            if (status == RsStatus.OK) {
                Digest digest = new DigestHeader(headers).value();
                result = new PublisherAs(body).bytes().thenApply(bytes -> Optional.of(new JsonManifest(digest, (byte[])bytes)));
            } else {
                result = status == RsStatus.NOT_FOUND ? CompletableFuture.completedFuture(Optional.empty()) : ProxyManifests.unexpected(status);
            }
            return result;
        }).result();
    }

    @Override
    public CompletionStage<Tags> tags(Optional<Tag> from, int limit) {
        return new ResponseSink(this.remote.response(new RequestLine(RqMethod.GET, new TagsListUri(this.name, from, limit).string()).toString(), (Iterable)Headers.EMPTY, (Publisher)Content.EMPTY), (status, headers, body) -> {
            CompletionStage<Object> result = status == RsStatus.OK ? new PublisherAs(body).bytes().thenApply(bytes -> () -> new Content.From(bytes)) : ProxyManifests.unexpected(status);
            return result;
        }).result();
    }

    private static <T> CompletionStage<T> unexpected(RsStatus status) {
        return new FailedCompletionStage((Throwable)new IllegalArgumentException(String.format("Unexpected status: %s", status)));
    }
}

