/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.proxy;

import com.artipie.docker.RepoName;
import com.artipie.docker.Tag;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TagsListUri {
    private final RepoName name;
    private final Optional<Tag> from;
    private final int limit;

    TagsListUri(RepoName name, Optional<Tag> from, int limit) {
        this.name = name;
        this.from = from;
        this.limit = limit;
    }

    public String string() {
        Stream<Object> nparam = this.limit < Integer.MAX_VALUE ? Stream.of(String.format("n=%d", this.limit)) : Stream.empty();
        List params = Stream.concat(nparam, this.from.map(last -> Stream.of(String.format("last=%s", last.value()))).orElseGet(Stream::empty)).collect(Collectors.toList());
        StringBuilder uri = new StringBuilder("/v2/").append(this.name.value()).append("/tags/list");
        if (!params.isEmpty()) {
            uri.append(String.format("?%s", Joiner.on((String)"&").join(params)));
        }
        return uri.toString();
    }
}

