/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.asto.Content;
import com.artipie.docker.Digest;
import com.artipie.docker.Docker;
import com.artipie.docker.Repo;
import com.artipie.docker.RepoName;
import com.artipie.docker.http.DigestHeader;
import com.artipie.docker.misc.RqByRegex;
import com.artipie.http.Connection;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.headers.Header;
import com.artipie.http.headers.Location;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

public final class UploadEntity {
    public static final Pattern PATH = Pattern.compile("^/v2/(?<name>.*)/blobs/uploads/(?<uuid>.*)$");

    private UploadEntity() {
    }

    private static class StatusResponse
    implements Response {
        private final RepoName name;
        private final String uuid;
        private final long offset;

        StatusResponse(RepoName name, String uuid, long offset) {
            this.name = name;
            this.uuid = uuid;
            this.offset = offset;
        }

        public CompletionStage<Void> send(Connection connection) {
            return new RsWithHeaders((Response)new RsWithStatus(RsStatus.ACCEPTED), new Map.Entry[]{new Location(String.format("/v2/%s/blobs/uploads/%s", this.name.value(), this.uuid)), new Header("Range", String.format("0-%d", this.offset)), new ContentLength("0"), new Header("Docker-Upload-UUID", this.uuid)}).send(connection);
        }
    }

    static final class Request {
        public static final Pattern QUERY = Pattern.compile("digest=(?<digest>[^=]*)");
        private final String line;

        Request(String line) {
            this.line = line;
        }

        RepoName name() {
            return new RepoName.Valid(new RqByRegex(this.line, PATH).path().group("name"));
        }

        String uuid() {
            return new RqByRegex(this.line, PATH).path().group("uuid");
        }

        Digest digest() {
            String query = Objects.requireNonNull(new RequestLineFrom(this.line).uri().getQuery(), String.format("No query in request: %s", this.line));
            Matcher matcher = QUERY.matcher(query);
            if (!matcher.matches()) {
                throw new IllegalStateException(String.format("Unexpected query: %s", query));
            }
            return new Digest.FromString(matcher.group("digest"));
        }
    }

    public static final class Get
    implements Slice {
        private final Docker docker;

        Get(Docker docker) {
            this.docker = docker;
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            String uuid = request.uuid();
            return new AsyncResponse(this.docker.repo(name).uploads().get(uuid).thenCompose(found -> found.map(upload -> upload.offset().thenApply(offset -> new RsWithHeaders((Response)new RsWithStatus(RsStatus.NO_CONTENT), new Map.Entry[]{new ContentLength("0"), new Header("Range", String.format("0-%d", offset)), new Header("Docker-Upload-UUID", uuid)}))).orElseGet(() -> CompletableFuture.completedStage(new RsWithStatus(RsStatus.NOT_FOUND)))));
        }
    }

    public static final class Put
    implements Slice {
        private final Docker docker;

        Put(Docker docker) {
            this.docker = docker;
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            String uuid = request.uuid();
            Repo repo = this.docker.repo(name);
            return new AsyncResponse(repo.uploads().get(uuid).thenCompose(found -> found.map(upload -> upload.content().thenCompose(content -> repo.layers().put((Content)content, request.digest()).handle((blob, throwable) -> {
                CompletionStage<Object> res = throwable == null ? upload.delete().thenApply(any -> Put.getResponse(name, request.digest())) : CompletableFuture.completedStage(new RsWithStatus(RsStatus.BAD_REQUEST));
                return res;
            }).thenCompose(Function.identity()))).orElseGet(() -> CompletableFuture.completedStage(new RsWithStatus(RsStatus.NOT_FOUND)))));
        }

        private static Response getResponse(RepoName name, Digest digest) {
            return new RsWithHeaders((Response)new RsWithStatus(RsStatus.CREATED), new Map.Entry[]{new Location(String.format("/v2/%s/blobs/%s", name.value(), digest.string())), new ContentLength("0"), new DigestHeader(digest)});
        }
    }

    public static final class Patch
    implements Slice {
        private final Docker docker;

        Patch(Docker docker) {
            this.docker = docker;
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            String uuid = request.uuid();
            return new AsyncResponse(this.docker.repo(name).uploads().get(uuid).thenCompose(found -> found.map(upload -> upload.append(body).thenApply(offset -> new StatusResponse(name, uuid, (long)offset))).orElseGet(() -> CompletableFuture.completedStage(new RsWithStatus(RsStatus.NOT_FOUND)))));
        }
    }

    public static final class Post
    implements Slice {
        private final Docker docker;

        Post(Docker docker) {
            this.docker = docker;
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            RepoName name = new Request(line).name();
            return new AsyncResponse(this.docker.repo(name).uploads().start().thenApply(upload -> new StatusResponse(name, upload.uuid(), 0L)));
        }
    }
}

