/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.helm.ChartYaml;
import com.artipie.helm.TgzArchive;
import com.artipie.helm.misc.DateTimeNow;
import io.vertx.core.impl.ConcurrentHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

interface Charts {
    public CompletionStage<Map<String, Set<String>>> versionsFor(Collection<Key> var1);

    public CompletionStage<Map<String, Set<Pair<String, ChartYaml>>>> versionsAndYamlFor(Collection<Key> var1);

    public static final class Asto
    implements Charts {
        private final Storage storage;

        Asto(Storage storage) {
            this.storage = storage;
        }

        @Override
        public CompletionStage<Map<String, Set<String>>> versionsFor(Collection<Key> charts) {
            ConcurrentHashMap pckgs = new ConcurrentHashMap();
            return CompletableFuture.allOf((CompletableFuture[])charts.stream().map(key -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.storage.value(key).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenApply(TgzArchive::new)).thenAccept(tgz -> {
                ChartYaml chart = tgz.chartYaml();
                pckgs.putIfAbsent(chart.name(), new HashSet());
                ((Set)pckgs.get(chart.name())).add(chart.version());
            })).toArray(CompletableFuture[]::new)).thenApply(noth -> pckgs);
        }

        @Override
        public CompletionStage<Map<String, Set<Pair<String, ChartYaml>>>> versionsAndYamlFor(Collection<Key> charts) {
            ConcurrentHashMap pckgs = new ConcurrentHashMap();
            return CompletableFuture.allOf((CompletableFuture[])charts.stream().map(key -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.storage.value(key).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenApply(TgzArchive::new)).thenAccept(tgz -> Asto.addChartFromTgzToPackages(tgz, pckgs))).toArray(CompletableFuture[]::new)).thenApply(noth -> pckgs);
        }

        private static void addChartFromTgzToPackages(TgzArchive tgz, Map<String, Set<Pair<String, ChartYaml>>> pckgs) {
            HashMap<String, Object> fields = new HashMap<String, Object>(tgz.chartYaml().fields());
            fields.putAll(tgz.metadata(Optional.empty()));
            fields.put("created", new DateTimeNow().asString());
            ChartYaml chart = new ChartYaml(fields);
            String name = chart.name();
            pckgs.putIfAbsent(name, (Set<Pair<String, ChartYaml>>)new ConcurrentHashSet());
            pckgs.get(name).add((Pair<String, ChartYaml>)new ImmutablePair((Object)chart.version(), (Object)chart));
        }
    }
}

