/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.ArtipieException;
import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.helm.metadata.Index;
import com.artipie.helm.metadata.ParsedChartName;
import com.artipie.helm.metadata.YamlWriter;
import com.artipie.helm.misc.LineWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface RemoveWriter {
    public CompletionStage<Void> delete(Path var1, Path var2, Map<String, Set<String>> var3);

    public static final class Asto
    implements RemoveWriter {
        static final String VRSNS = "version:";
        static final String ENTRS = "entries:";
        private final Storage storage;

        Asto(Storage storage) {
            this.storage = storage;
        }

        @Override
        public CompletionStage<Void> delete(Path source, Path out, Map<String, Set<String>> todelete) {
            return new Index.WithBreaks(this.storage).versionsByPackages((Key)new Key.From(source.getFileName().toString())).thenCompose(fromidx -> {
                Asto.checkExistenceChartsToDelete(fromidx, todelete);
                return CompletableFuture.allOf(new CompletableFuture[0]);
            }).thenCompose(noth -> {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(source, new OpenOption[0])));
                     BufferedWriter bufw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(out, new OpenOption[0])));){
                    String line;
                    boolean entrs = false;
                    String name = null;
                    ArrayList<String> lines = new ArrayList<String>(2);
                    YamlWriter writer = new YamlWriter(bufw, 2);
                    LineWriter linewrtr = new LineWriter(writer);
                    while ((line = br.readLine()) != null) {
                        String trimmed = line.trim();
                        int posspace = Asto.lastPosOfSpaceInBegin(line);
                        if (!entrs) {
                            entrs = trimmed.equals(ENTRS);
                        }
                        if (entrs && new ParsedChartName(line).valid()) {
                            if (name == null) {
                                writer = new YamlWriter(bufw, posspace);
                                linewrtr = new LineWriter(writer);
                            }
                            if (posspace == writer.indent()) {
                                if (name != null) {
                                    Asto.writeIfNotContainInDeleted(lines, todelete, writer);
                                }
                                name = trimmed.replace(":", "");
                            }
                        }
                        if (entrs && name != null && posspace == 0) {
                            entrs = false;
                            Asto.writeIfNotContainInDeleted(lines, todelete, writer);
                        }
                        if (entrs && name != null) {
                            lines.add(line);
                        }
                        if (!lines.isEmpty()) continue;
                        linewrtr.writeAndReplaceTagGenerated(line);
                    }
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
                return CompletableFuture.allOf(new CompletableFuture[0]);
            });
        }

        private static void writeIfNotContainInDeleted(List<String> lines, Map<String, Set<String>> pckgs, YamlWriter writer) throws IOException {
            ChartVersions items = new ChartVersions(lines);
            String name = items.name().trim().replace(":", "");
            Map<String, List<String>> vrsns = items.versions();
            boolean recordedname = false;
            if (pckgs.containsKey(name)) {
                for (String vers : vrsns.keySet()) {
                    if (pckgs.get(name).contains(vers)) continue;
                    if (!recordedname) {
                        recordedname = true;
                        writer.writeLine(items.name(), 0);
                    }
                    List<String> entry = vrsns.get(vers);
                    for (String line : entry) {
                        writer.writeLine(line, 0);
                    }
                }
            } else {
                for (String line : lines) {
                    writer.writeLine(line, 0);
                }
            }
            lines.clear();
        }

        private static void checkExistenceChartsToDelete(Map<String, Set<String>> fromidx, Map<String, Set<String>> todelete) {
            for (String pckg : todelete.keySet()) {
                if (!fromidx.containsKey(pckg)) {
                    throw new ArtipieException((Throwable)new IllegalStateException(String.format("Failed to delete package `%s` as it is absent in index", pckg)));
                }
                for (String vrsn : todelete.get(pckg)) {
                    if (fromidx.get(pckg).contains(vrsn)) continue;
                    throw new ArtipieException((Throwable)new IllegalStateException(String.format("Failed to delete package `%s` with version `%s` as it is absent in index", pckg, vrsn)));
                }
            }
        }

        private static int lastPosOfSpaceInBegin(String line) {
            return line.length() - line.replaceAll("^\\s*", "").length();
        }

        private static final class ChartVersions {
            private final List<String> lines;

            ChartVersions(List<String> lines) {
                this.lines = lines;
            }

            public Map<String, List<String>> versions() {
                HashMap<String, List<String>> vrsns = new HashMap<String, List<String>>();
                int dash = 45;
                if (this.lines.size() > 1) {
                    int indent = this.lines.get(1).indexOf(45);
                    ArrayList<String> tmp = new ArrayList<String>(2);
                    for (int idx = 1; idx < this.lines.size(); ++idx) {
                        if (this.lines.get(idx).charAt(indent) == '-' && !tmp.isEmpty()) {
                            vrsns.put(ChartVersions.version(tmp), new ArrayList<String>(tmp));
                            tmp.clear();
                        }
                        tmp.add(this.lines.get(idx));
                    }
                    vrsns.put(ChartVersions.version(tmp), new ArrayList<String>(tmp));
                }
                return vrsns;
            }

            public String name() {
                if (!this.lines.isEmpty()) {
                    return this.lines.get(0);
                }
                throw new IllegalStateException("Failed to get name as there are no lines");
            }

            private static String version(List<String> entry) {
                return entry.stream().filter(line -> line.trim().startsWith(Asto.VRSNS)).map(line -> line.replace(Asto.VRSNS, "")).map(String::trim).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find version for deletion"));
            }
        }
    }
}

