/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm.http;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.helm.ChartYaml;
import com.artipie.helm.TgzArchive;
import com.artipie.helm.metadata.IndexYaml;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import io.reactivex.Single;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

final class DeleteChartSlice
implements Slice {
    static final Pattern PTRN_DEL_CHART = Pattern.compile("^/charts/(?<name>[a-zA-Z\\-\\d.]+)/?(?<version>[a-zA-Z\\-\\d.]*)$");
    private final Storage storage;

    DeleteChartSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RsWithStatus res;
        URI uri = new RequestLineFrom(line).uri();
        Matcher matcher = PTRN_DEL_CHART.matcher(uri.getPath());
        if (matcher.matches()) {
            String chart = matcher.group("name");
            String vers = matcher.group("version");
            res = vers.isEmpty() ? new AsyncResponse(new IndexYaml(this.storage).deleteByName(chart).andThen(this.deleteArchives(chart, Optional.empty()))) : new AsyncResponse(new IndexYaml(this.storage).deleteByNameAndVersion(chart, vers).andThen(this.deleteArchives(chart, Optional.of(vers))));
        } else {
            res = new RsWithStatus(RsStatus.BAD_REQUEST);
        }
        return res;
    }

    private Single<Response> deleteArchives(String name, Optional<String> vers) {
        AtomicBoolean wasdeleted = new AtomicBoolean();
        return Single.fromFuture((Future)((Object)((CompletableFuture)this.storage.list(Key.ROOT).thenApply(keys -> keys.stream().filter(key -> key.string().endsWith(".tgz")).collect(Collectors.toList()))).thenCompose(keys -> CompletableFuture.allOf((CompletableFuture[])keys.stream().map(key -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.storage.value(key).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenApply(TgzArchive::new)).thenCompose(tgz -> {
            ChartYaml chart = tgz.chartYaml();
            CompletionStage<Void> res = chart.name().equals(name) ? this.wasChartDeleted(chart, vers, (Key)key).thenCompose(wasdel -> {
                wasdeleted.compareAndSet(false, (boolean)wasdel);
                return CompletableFuture.allOf(new CompletableFuture[0]);
            }) : CompletableFuture.allOf(new CompletableFuture[0]);
            return res;
        })).toArray(CompletableFuture[]::new)).thenApply(noth -> {
            StandardRs resp = wasdeleted.get() ? StandardRs.OK : StandardRs.NOT_FOUND;
            return resp;
        }))));
    }

    private CompletionStage<Boolean> wasChartDeleted(ChartYaml chart, Optional<String> vers, Key key) {
        CompletableFuture<Boolean> res = !vers.isPresent() || chart.version().equals(vers.get()) ? this.storage.exists(key).thenCompose(exists -> {
            CompletionStage<Boolean> result = exists != false ? this.storage.delete(key).thenApply(noth -> true) : CompletableFuture.completedFuture(false);
            return result;
        }) : CompletableFuture.completedFuture(false);
        return res;
    }
}

