/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm.metadata;

import com.artipie.asto.Content;
import com.artipie.helm.misc.DateTimeNow;
import com.artipie.helm.misc.EmptyIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class IndexYamlMapping {
    private static final String ENTRS = "entries";
    private static final String VRSN = "version";
    private final Map<String, Object> mapping;

    public IndexYamlMapping() {
        this(new EmptyIndex().asString());
    }

    public IndexYamlMapping(String yaml) {
        this((Map)new Yaml().load(yaml));
    }

    public IndexYamlMapping(Map<String, Object> mapfromindex) {
        this.mapping = mapfromindex;
    }

    public Map<String, Object> entries() {
        this.mapping.computeIfAbsent(ENTRS, k -> new HashMap());
        return (Map)this.mapping.get(ENTRS);
    }

    public List<Map<String, Object>> byChart(String chartname) {
        this.entries().computeIfAbsent(chartname, nothing -> new ArrayList(0));
        return (List)this.entries().get(chartname);
    }

    public Optional<Map<String, Object>> byChartAndVersion(String chartname, String version) {
        return this.byChart(chartname).stream().filter(entry -> entry.get(VRSN).equals(version)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChartVersions(String name, List<Map<String, Object>> versions) {
        Map<String, Object> map = this.mapping;
        synchronized (map) {
            Map<String, Object> entr = this.entries();
            versions.forEach(vers -> vers.put("created", new DateTimeNow().asString()));
            if (entr.containsKey(name)) {
                List<Map<String, Object>> existed = this.byChart(name);
                for (Map<String, Object> vers2 : versions) {
                    Optional<Map<String, Object>> opt = this.byChartAndVersion(name, (String)vers2.get(VRSN));
                    if (opt.isPresent()) {
                        existed.removeIf(chart -> chart.get(VRSN).equals(((Map)opt.get()).get(VRSN)));
                    }
                    existed.add(vers2);
                }
            } else {
                entr.put(name, versions);
            }
        }
    }

    public Optional<Content> toContent() {
        Optional<Content> res;
        if (this.entries().isEmpty()) {
            res = Optional.empty();
        } else {
            this.mapping.put("generated", new DateTimeNow().asString());
            res = Optional.of(new Content.From(this.toString().getBytes()));
        }
        return res;
    }

    public String toString() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        return new Yaml(options).dump(this.mapping);
    }
}

