/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.ArtipieException;
import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Copy;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import com.artipie.helm.AddWriter;
import com.artipie.helm.ChartYaml;
import com.artipie.helm.Charts;
import com.artipie.helm.RemoveWriter;
import com.artipie.helm.metadata.IndexYaml;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;

public interface Helm {
    public CompletionStage<Void> batchUpdate(Key var1);

    public CompletionStage<Void> add(Collection<Key> var1, Key var2);

    public CompletionStage<Void> delete(Collection<Key> var1, Key var2);

    public CompletionStage<Void> reindex(Key var1);

    public static final class Asto
    implements Helm {
        private final Storage storage;

        Asto(Storage storage) {
            this.storage = storage;
        }

        @Override
        public CompletionStage<Void> batchUpdate(Key prefix) {
            throw new NotImplementedException("not implemented yet");
        }

        @Override
        public CompletionStage<Void> add(Collection<Key> charts, Key indexpath) {
            AtomicReference dir = new AtomicReference();
            Key.From keyidx = new Key.From(indexpath, IndexYaml.INDEX_YAML);
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            ((CompletableFuture)CompletableFuture.runAsync(() -> Asto.throwIfKeysInvalid(charts, indexpath)).thenCompose(arg_0 -> this.lambda$add$4(charts, dir, (Key)keyidx, result, arg_0))).handle((noth, thr) -> {
                if (thr == null) {
                    result.complete(null);
                } else {
                    result.completeExceptionally((Throwable)thr);
                }
                return null;
            });
            return result;
        }

        @Override
        public CompletionStage<Void> delete(Collection<Key> charts, Key indexpath) {
            CompletionStage<Void> res;
            if (charts.isEmpty()) {
                res = CompletableFuture.allOf(new CompletableFuture[0]);
            } else {
                AtomicReference dir = new AtomicReference();
                Key.From keyidx = new Key.From(indexpath, IndexYaml.INDEX_YAML);
                res = this.storage.exists((Key)keyidx).thenCompose(arg_0 -> this.lambda$delete$12(charts, indexpath, dir, (Key)keyidx, arg_0));
            }
            return res;
        }

        @Override
        public CompletionStage<Void> reindex(Key prefix) {
            AtomicReference dir = new AtomicReference();
            AtomicReference out = new AtomicReference();
            Key.From keyidx = new Key.From(prefix, IndexYaml.INDEX_YAML);
            String tmpout = String.format("index-%s-out.yaml", UUID.randomUUID().toString());
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            ((CompletableFuture)CompletableFuture.runAsync(() -> {
                String prfx = "index-";
                try {
                    dir.set(Files.createTempDirectory("index-", new FileAttribute[0]));
                    out.set(Files.createTempFile((Path)dir.get(), "index-", "-out.yaml", new FileAttribute[0]));
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
            }).thenCompose(arg_0 -> this.lambda$reindex$19(tmpout, prefix, dir, out, (Key)keyidx, arg_0))).handle((noth, thr) -> {
                if (thr == null) {
                    result.complete(null);
                } else {
                    FileUtils.deleteQuietly((File)((Path)out.get()).getParent().toFile());
                    result.completeExceptionally((Throwable)thr);
                }
                return null;
            });
            return result;
        }

        private CompletableFuture<Void> checkAllChartsExistence(Collection<Key> charts) {
            List<CompletableFuture> futures = charts.stream().map(arg_0 -> ((Storage)this.storage).exists(arg_0)).collect(Collectors.toList());
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenCompose(nothing -> {
                if (futures.stream().anyMatch(res -> !((Boolean)res.toCompletableFuture().join()).equals(true))) {
                    throw new ArtipieException((Throwable)new IllegalStateException("Some of keys for deletion are absent in storage"));
                }
                return CompletableFuture.allOf(new CompletableFuture[0]);
            });
        }

        private CompletionStage<Void> moveFromTempStorageAndDelete(Storage tmpstrg, Key outidx, Path tmpdir, Key idxtarget) {
            return ((CompletableFuture)((CompletableFuture)new Copy(tmpstrg, Collections.singletonList(outidx)).copy(this.storage).thenCompose(noth -> this.storage.move(outidx, idxtarget))).thenApply(noth -> FileUtils.deleteQuietly((File)tmpdir.toFile()))).thenCompose(ignore -> CompletableFuture.allOf(new CompletableFuture[0]));
        }

        private static void throwIfKeysInvalid(Collection<Key> keys, Key prefix) {
            keys.forEach(key -> {
                if (!key.string().startsWith(prefix.string())) {
                    throw new ArtipieException((Throwable)new IllegalStateException(String.format("Key `%s` does not start with prefix `%s`", key.string(), prefix.string())));
                }
            });
        }

        private /* synthetic */ CompletionStage lambda$reindex$19(String tmpout, Key prefix, AtomicReference dir, AtomicReference out, Key keyidx, Void nothing) {
            return ((CompletableFuture)((CompletableFuture)this.storage.save((Key)new Key.From(tmpout), Content.EMPTY).thenCompose(noth -> this.storage.list(prefix))).thenApply(keys -> keys.stream().filter(key -> key.string().endsWith(".tgz")).collect(Collectors.toSet()))).thenCompose(keys -> {
                FileStorage tmpstrg = new FileStorage((Path)dir.get());
                TreeSet<Key> tgzs = new TreeSet<Key>(Key.CMP_STRING);
                tgzs.addAll((Collection<Key>)keys);
                return new AddWriter.Asto(this.storage).addTrustfully((Path)out.get(), tgzs).thenCompose(arg_0 -> this.lambda$null$17((Storage)tmpstrg, out, dir, keyidx, arg_0));
            });
        }

        private /* synthetic */ CompletionStage lambda$null$17(Storage tmpstrg, AtomicReference out, AtomicReference dir, Key keyidx, Void noth) {
            return this.moveFromTempStorageAndDelete(tmpstrg, (Key)new Key.From(((Path)out.get()).getFileName().toString()), (Path)dir.get(), keyidx);
        }

        private /* synthetic */ CompletionStage lambda$delete$12(Collection charts, Key indexpath, AtomicReference dir, Key keyidx, Boolean exists) {
            Asto.throwIfKeysInvalid(charts, indexpath);
            if (exists.booleanValue()) {
                try {
                    String prfx = "index-";
                    AtomicReference outidx = new AtomicReference();
                    AtomicReference out = new AtomicReference();
                    AtomicReference tmpstrg = new AtomicReference();
                    CompletableFuture rslt = new CompletableFuture();
                    ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkAllChartsExistence(charts).thenAccept(noth -> {
                        try {
                            dir.set(Files.createTempDirectory("index-", new FileAttribute[0]));
                            out.set(Files.createTempFile((Path)dir.get(), "index-", "-out.yaml", new FileAttribute[0]));
                        }
                        catch (IOException exc) {
                            throw new ArtipieIOException(exc);
                        }
                        tmpstrg.set(new FileStorage((Path)dir.get()));
                        outidx.set(new Key.From(((Path)out.get()).getFileName().toString()));
                    })).thenCombine(new Charts.Asto(this.storage).versionsFor(charts), (noth, fromidx) -> new RemoveWriter.Asto(this.storage).delete(keyidx, (Path)out.get(), (Map<String, Set<String>>)fromidx))).thenCompose(Function.identity())).thenCompose(noth -> this.moveFromTempStorageAndDelete((Storage)tmpstrg.get(), (Key)outidx.get(), (Path)dir.get(), keyidx))).thenCompose(noth -> CompletableFuture.allOf((CompletableFuture[])charts.stream().map(arg_0 -> ((Storage)this.storage).delete(arg_0)).toArray(CompletableFuture[]::new)))).handle((noth, thr) -> {
                        if (thr == null) {
                            rslt.complete(null);
                        } else {
                            if (out.get() != null) {
                                FileUtils.deleteQuietly((File)((Path)out.get()).getParent().toFile());
                            }
                            rslt.completeExceptionally((Throwable)thr);
                        }
                        return null;
                    });
                    return rslt;
                }
                catch (IllegalStateException exc) {
                    FileUtils.deleteQuietly((File)((Path)dir.get()).toFile());
                    throw new ArtipieException((Throwable)exc);
                }
            }
            throw new ArtipieException("Failed to delete packages as index does not exist");
        }

        private /* synthetic */ CompletionStage lambda$add$4(Collection charts, AtomicReference dir, Key keyidx, CompletableFuture result, Void nothing) {
            return new Charts.Asto(this.storage).versionsAndYamlFor(charts).thenCompose(pckgs -> {
                try {
                    String prfx = "index-";
                    dir.set(Files.createTempDirectory("index-", new FileAttribute[0]));
                    Path out = Files.createTempFile((Path)dir.get(), "index-", "-out.yaml", new FileAttribute[0]);
                    Key.From outidx = new Key.From(out.getFileName().toString());
                    FileStorage tmpstrg = new FileStorage((Path)dir.get());
                    return new AddWriter.Asto(this.storage).add(keyidx, out, (Map<String, Set<Pair<String, ChartYaml>>>)pckgs).thenCompose(arg_0 -> this.lambda$null$1((Storage)tmpstrg, (Key)outidx, dir, keyidx, arg_0)).handle((noth, thr) -> {
                        if (thr == null) {
                            result.complete(null);
                        } else {
                            FileUtils.deleteQuietly((File)out.getParent().toFile());
                            result.completeExceptionally((Throwable)thr);
                        }
                        return null;
                    });
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
            });
        }

        private /* synthetic */ CompletionStage lambda$null$1(Storage tmpstrg, Key outidx, AtomicReference dir, Key keyidx, Void noth) {
            return this.moveFromTempStorageAndDelete(tmpstrg, outidx, (Path)dir.get(), keyidx);
        }
    }
}

