/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.asto.ArtipieIOException;
import com.artipie.helm.ChartYaml;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public final class TgzArchive {
    private final byte[] content;
    private final ChartYaml chart;

    public TgzArchive(byte[] content) {
        this.content = content;
        this.chart = new ChartYaml(this.file("Chart.yaml"));
    }

    public String name() {
        return String.format("%s-%s.tgz", this.chart.name(), this.chart.version());
    }

    public Map<String, Object> metadata(Optional<String> baseurl) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("urls", new ArrayList<String>(Collections.singletonList(String.format("%s%s", baseurl.orElse(""), this.name()))));
        meta.put("digest", DigestUtils.sha256Hex((byte[])this.content));
        meta.putAll(this.chart.fields());
        return meta;
    }

    public ChartYaml chartYaml() {
        return this.chart;
    }

    public byte[] bytes() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    public long size() {
        return this.content.length;
    }

    private String file(String name) {
        try {
            TarArchiveEntry entry;
            TarArchiveInputStream taris = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new ByteArrayInputStream(this.content)));
            while ((entry = taris.getNextTarEntry()) != null) {
                if (!entry.getName().endsWith(name)) continue;
                return new BufferedReader(new InputStreamReader((InputStream)taris)).lines().collect(Collectors.joining("\n"));
            }
            throw new IllegalStateException(String.format("'%s' file wasn't found", name));
        }
        catch (IOException exc) {
            throw new ArtipieIOException(exc);
        }
    }
}

