/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm.http;

import com.artipie.ArtipieException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.helm.ChartYaml;
import com.artipie.helm.metadata.IndexYamlMapping;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import com.artipie.http.slice.KeyFromPath;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

final class DownloadIndexSlice
implements Slice {
    static final Pattern PTRN = Pattern.compile(".*index.yaml$");
    private final URL base;
    private final Storage storage;

    DownloadIndexSlice(String base, Storage storage) {
        this.base = DownloadIndexSlice.url(base);
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RsWithStatus resp;
        RequestLineFrom rqline = new RequestLineFrom(line);
        String uri = rqline.uri().getPath();
        Matcher matcher = PTRN.matcher(uri);
        if (matcher.matches()) {
            KeyFromPath path = new KeyFromPath(uri);
            resp = new AsyncResponse(this.storage.exists((Key)path).thenCompose(arg_0 -> this.lambda$response$2((Key)path, arg_0)));
        } else {
            resp = new RsWithStatus(RsStatus.BAD_REQUEST);
        }
        return resp;
    }

    private static URL url(String url) {
        try {
            return URI.create(url.replaceAll("/$", "")).toURL();
        }
        catch (MalformedURLException exc) {
            throw new ArtipieException((Throwable)new IllegalStateException(String.format("Failed to build URL from '%s'", url), exc));
        }
    }

    private /* synthetic */ CompletionStage lambda$response$2(Key path, Boolean exists) {
        CompletionStage<Object> rsp = exists != false ? ((CompletableFuture)this.storage.value(path).thenCompose(content -> new UpdateIndexUrls((Content)content, this.base).value())).thenApply(content -> new RsFull(RsStatus.OK, (Iterable)Headers.EMPTY, content)) : CompletableFuture.completedFuture(StandardRs.NOT_FOUND);
        return rsp;
    }

    private static final class UpdateIndexUrls {
        private final Content original;
        private final URL base;

        UpdateIndexUrls(Content original, URL base) {
            this.original = original;
            this.base = base;
        }

        public CompletionStage<Content> value() {
            return new PublisherAs(this.original).bytes().thenApply(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).thenApply(IndexYamlMapping::new).thenApply(this::update).thenApply(idx -> idx.toContent().get());
        }

        private IndexYamlMapping update(IndexYamlMapping index) {
            Set<String> entrs = index.entries().keySet();
            entrs.forEach(chart -> index.byChart((String)chart).forEach(entr -> {
                List<String> urls = new ChartYaml((Map<String, Object>)entr).urls();
                entr.put("urls", urls.stream().map(this::baseUrlWithUri).collect(Collectors.toList()));
            }));
            return index;
        }

        private String baseUrlWithUri(String uri) {
            String unsafe = String.format("%s/%s", this.base, uri);
            try {
                return new URI(unsafe).toString();
            }
            catch (URISyntaxException exc) {
                throw new IllegalStateException(String.format("Failed to create URI from `%s`", unsafe), exc);
            }
        }
    }
}

