/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.asto.Key;
import com.artipie.nuget.PackageKeys;
import com.artipie.nuget.metadata.NuspecField;

public final class PackageIdentity {
    private final NuspecField id;
    private final NuspecField version;

    public PackageIdentity(NuspecField id, NuspecField version) {
        this.id = id;
        this.version = version;
    }

    public Key nupkgKey() {
        return new Key.From(this.rootKey(), new String[]{String.format("%s.%s.nupkg", this.id.normalized(), this.version.normalized())});
    }

    public Key hashKey() {
        return new Key.From(this.rootKey(), new String[]{String.format("%s.%s.nupkg.sha512", this.id.normalized(), this.version.normalized())});
    }

    public Key nuspecKey() {
        return new Key.From(this.rootKey(), new String[]{String.format("%s.nuspec", this.id.normalized())});
    }

    public Key rootKey() {
        return new Key.From(new PackageKeys(this.id).rootKey(), new String[]{this.version.normalized()});
    }

    public String toString() {
        return String.format("Package: '%s' Version: '%s'", this.id, this.version);
    }
}

