/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http;

import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.OperationControl;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.nuget.Repository;
import com.artipie.nuget.http.BasicAuthRoute;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.RouteService;
import com.artipie.nuget.http.RoutingResource;
import com.artipie.nuget.http.content.PackageContent;
import com.artipie.nuget.http.index.ServiceIndex;
import com.artipie.nuget.http.metadata.PackageMetadata;
import com.artipie.nuget.http.publish.PackagePublish;
import com.artipie.scheduling.ArtifactEvent;
import com.artipie.security.perms.Action;
import com.artipie.security.perms.AdapterBasicPermission;
import com.artipie.security.policy.Policy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.reactivestreams.Publisher;

public final class NuGet
implements Slice {
    private final URL url;
    private final Repository repository;
    private final Policy<?> policy;
    private final Authentication users;
    private final String name;
    private final Optional<Queue<ArtifactEvent>> events;

    public NuGet(URL url, Repository repository) {
        this(url, repository, Policy.FREE, Authentication.ANONYMOUS, "*", Optional.empty());
    }

    public NuGet(URL url, Repository repository, Policy<?> policy, Authentication users, String name, Optional<Queue<ArtifactEvent>> events) {
        this.url = url;
        this.repository = repository;
        this.policy = policy;
        this.users = users;
        this.name = name;
        this.events = events;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RequestLineFrom request = new RequestLineFrom(line);
        String path = request.uri().getPath();
        Resource resource = this.resource(path);
        RqMethod method = request.method();
        Object response = method.equals((Object)RqMethod.GET) ? resource.get((Headers)new Headers.From(headers)) : (method.equals((Object)RqMethod.PUT) ? resource.put((Headers)new Headers.From(headers), body) : new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED));
        return response;
    }

    private Resource resource(String path) {
        PackagePublish publish = new PackagePublish(this.repository, this.events, this.name);
        PackageContent content = new PackageContent(this.url, this.repository);
        PackageMetadata metadata = new PackageMetadata(this.repository, content);
        return new RoutingResource(path, new ServiceIndex(Arrays.asList(new RouteService(this.url, publish, "PackagePublish/2.0.0"), new RouteService(this.url, metadata, "RegistrationsBaseUrl/Versioned"), new RouteService(this.url, content, "PackageBaseAddress/3.0.0"))), this.auth(publish, (Action)Action.Standard.WRITE), this.auth(content, (Action)Action.Standard.READ), this.auth(metadata, (Action)Action.Standard.READ));
    }

    private Route auth(Route route, Action action) {
        return new BasicAuthRoute(route, new OperationControl(this.policy, (Permission)new AdapterBasicPermission(this.name, action)), this.users);
    }
}

