/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http;

import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.index.Service;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;

final class RouteService
implements Service {
    private final URL base;
    private final Route route;
    private final String stype;

    RouteService(URL base, Route route, String stype) {
        this.base = base;
        this.route = route;
        this.stype = stype;
    }

    @Override
    public String url() {
        String path = String.format("%s%s", this.base.getPath(), this.route.path());
        String file = Optional.ofNullable(this.base.getQuery()).map(query -> String.format("%s?%s", path, this.base.getQuery())).orElse(path);
        try {
            return new URL(this.base.getProtocol(), this.base.getHost(), this.base.getPort(), file).toString();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(String.format("Failed to build URL from base: '%s'", this.base), ex);
        }
    }

    @Override
    public String type() {
        return this.stype;
    }
}

