/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.nuget.NuGetPackage;
import com.artipie.nuget.metadata.CatalogEntry;
import com.artipie.nuget.metadata.Nuspec;
import com.artipie.nuget.metadata.PackageId;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.maven.artifact.versioning.ComparableVersion;

public abstract class IndexJson {
    private static final String NULL = "null";
    private static final String ID = "@id";
    private static final String ITEMS = "items";
    private static final String CATALOG_ENTRY = "catalogEntry";
    private static final String COUNT = "count";
    private static final String LOWER = "lower";
    private static final String UPPER = "upper";

    private static void addIdAndCount(JsonObjectBuilder res, String id, int cnt) {
        res.add(ID, id);
        res.add(COUNT, cnt);
    }

    private static String version(JsonObject val) {
        return val.getJsonObject(CATALOG_ENTRY).getString("version");
    }

    private static Optional<JsonArray> itemsJsonArray(JsonObject source) {
        JsonObject obj;
        Optional<JsonArray> res = Optional.empty();
        if (source.containsKey((Object)ITEMS) && !source.getJsonArray(ITEMS).isEmpty() && (obj = ((JsonValue)source.getJsonArray(ITEMS).get(0)).asJsonObject()).containsKey((Object)ITEMS) && !obj.getJsonArray(ITEMS).isEmpty()) {
            res = Optional.of(obj.getJsonArray(ITEMS));
        }
        return res;
    }

    public static final class Update
    extends IndexJson {
        private final Optional<InputStream> input;

        public Update(Optional<InputStream> input) {
            this.input = input;
        }

        public Update() {
            this(Optional.empty());
        }

        public Update(InputStream input) {
            this(Optional.of(input));
        }

        public JsonObject perform(NuGetPackage pkg) {
            JsonObjectBuilder res = Json.createObjectBuilder();
            Nuspec nuspec = pkg.nuspec();
            JsonObject newest = Update.newPackageJsonItem(nuspec);
            String version = nuspec.version().normalized();
            JsonArrayBuilder itemsbuilder = Json.createArrayBuilder();
            if (this.input.isPresent()) {
                JsonObject old = Json.createReader((InputStream)this.input.get()).readObject();
                List<JsonObject> list = Update.sortedPackages(newest, version, old);
                list.forEach(arg_0 -> ((JsonArrayBuilder)itemsbuilder).add(arg_0));
                IndexJson.addIdAndCount(res, old.getString(IndexJson.ID, IndexJson.NULL), list.size());
            } else {
                itemsbuilder.add((JsonValue)newest);
                IndexJson.addIdAndCount(res, IndexJson.NULL, 1);
            }
            JsonArray items = itemsbuilder.build();
            res.add(IndexJson.UPPER, IndexJson.version(((JsonValue)items.get(items.size() - 1)).asJsonObject()));
            res.add(IndexJson.LOWER, IndexJson.version(((JsonValue)items.get(0)).asJsonObject()));
            res.add(IndexJson.ITEMS, (JsonValue)items);
            return Json.createObjectBuilder().add(IndexJson.COUNT, 1).add(IndexJson.ITEMS, Json.createArrayBuilder().add(res)).build();
        }

        private static List<JsonObject> sortedPackages(JsonObject newest, String version, JsonObject old) {
            List<JsonObject> list = Collections.singletonList(newest);
            Optional<JsonArray> array = IndexJson.itemsJsonArray(old);
            if (array.isPresent()) {
                JsonArray arr = array.get();
                list = new ArrayList<JsonObject>(arr.size() + 1);
                arr.stream().map(JsonValue::asJsonObject).filter(val -> !version.equals(IndexJson.version(val))).forEach(list::add);
                list.add(newest);
                list.sort(Comparator.comparing(val -> new ComparableVersion(IndexJson.version(val))));
            }
            return list;
        }

        private static JsonObject newPackageJsonItem(Nuspec nuspec) {
            return Json.createObjectBuilder().add(IndexJson.ID, IndexJson.NULL).add("packageContent", IndexJson.NULL).add(IndexJson.CATALOG_ENTRY, (JsonValue)new CatalogEntry.FromNuspec(nuspec).asJson()).build();
        }
    }

    public static final class Delete
    extends IndexJson {
        private final InputStream input;

        public Delete(InputStream input) {
            this.input = input;
        }

        public JsonObject perform(String name, String version) {
            JsonObjectBuilder res = Json.createObjectBuilder();
            Optional<JsonArray> array = IndexJson.itemsJsonArray(Json.createReader((InputStream)this.input).readObject());
            List<JsonObject> items = Collections.emptyList();
            if (array.isPresent()) {
                items = array.get().stream().map(JsonValue::asJsonObject).filter(item -> {
                    JsonObject entry = item.getJsonObject(IndexJson.CATALOG_ENTRY);
                    return !new PackageId(entry.getString("id")).normalized().equals(new PackageId(name).normalized()) || !new ComparableVersion(IndexJson.version(item)).equals((Object)new ComparableVersion(version));
                }).sorted(Comparator.comparing(val -> new ComparableVersion(IndexJson.version(val)))).collect(Collectors.toList());
            }
            if (!items.isEmpty()) {
                JsonObjectBuilder jitems = Json.createObjectBuilder();
                jitems.add(IndexJson.LOWER, IndexJson.version((JsonObject)items.get(0)));
                jitems.add(IndexJson.UPPER, IndexJson.version((JsonObject)items.get(items.size() - 1)));
                IndexJson.addIdAndCount(jitems, IndexJson.NULL, items.size());
                JsonArrayBuilder builder = Json.createArrayBuilder();
                items.forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
                jitems.add(IndexJson.ITEMS, builder);
                res.add(IndexJson.COUNT, 1).add(IndexJson.ITEMS, Json.createArrayBuilder().add(jitems));
            }
            return res.build();
        }
    }
}

