/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http;

import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqMethod;
import com.artipie.nuget.http.Resource;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;

final class ResourceFromSlice
implements Resource {
    private final String path;
    private final Slice origin;

    ResourceFromSlice(String path, Slice origin) {
        this.path = path;
        this.origin = origin;
    }

    @Override
    public Response get(Headers headers) {
        return this.delegate(RqMethod.GET, headers, (Publisher<ByteBuffer>)Flowable.empty());
    }

    @Override
    public Response put(Headers headers, Publisher<ByteBuffer> body) {
        return this.delegate(RqMethod.PUT, headers, body);
    }

    private Response delegate(RqMethod method, Headers headers, Publisher<ByteBuffer> body) {
        return this.origin.response(new RequestLine(method.value(), this.path).toString(), (Iterable)headers, body);
    }
}

