/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.index;

import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.nuget.http.Absent;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.RsWithBodyNoHeaders;
import com.artipie.nuget.http.index.Service;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonWriter;
import org.reactivestreams.Publisher;

public final class ServiceIndex
implements Route {
    private final Iterable<Service> services;

    public ServiceIndex(Iterable<Service> services) {
        this.services = services;
    }

    @Override
    public String path() {
        return "/";
    }

    @Override
    public Resource resource(String path) {
        Resource resource = "/index.json".equals(path) ? new Index() : new Absent();
        return resource;
    }

    private final class Index
    implements Resource {
        private Index() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public Response get(Headers headers) {
            JsonArrayBuilder resources = Json.createArrayBuilder();
            for (Service service : ServiceIndex.this.services) {
                resources.add(Json.createObjectBuilder().add("@id", service.url()).add("@type", service.type()));
            }
            JsonObject json = Json.createObjectBuilder().add("version", "3.0.0").add("resources", resources).build();
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                RsWithStatus rsWithStatus;
                block14: {
                    JsonWriter writer = Json.createWriter((OutputStream)out);
                    try {
                        writer.writeObject(json);
                        out.flush();
                        rsWithStatus = new RsWithStatus((Response)new RsWithBodyNoHeaders(out.toByteArray()), RsStatus.OK);
                        if (writer == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    writer.close();
                }
                return rsWithStatus;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to serialize JSON to bytes", ex);
            }
        }

        @Override
        public Response put(Headers headers, Publisher<ByteBuffer> body) {
            return new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
        }
    }
}

