/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.metadata;

import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.nuget.PackageKeys;
import com.artipie.nuget.Repository;
import com.artipie.nuget.Versions;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.RsWithBodyNoHeaders;
import com.artipie.nuget.http.metadata.CompletionStages;
import com.artipie.nuget.http.metadata.ContentLocation;
import com.artipie.nuget.http.metadata.RegistrationPage;
import com.artipie.nuget.metadata.NuspecField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.reactivestreams.Publisher;

class Registration
implements Resource {
    private final Repository repository;
    private final ContentLocation content;
    private final NuspecField id;

    Registration(Repository repository, ContentLocation content, NuspecField id) {
        this.repository = repository;
        this.content = content;
        this.id = id;
    }

    @Override
    public Response get(Headers headers) {
        return new AsyncResponse(this.pages().thenCompose(pages -> new CompletionStages(pages.stream().map(RegistrationPage::json)).all()).thenApply(pages -> {
            JsonArrayBuilder items = Json.createArrayBuilder();
            for (JsonObject page : pages) {
                items.add((JsonValue)page);
            }
            JsonObject json = Json.createObjectBuilder().add("count", pages.size()).add("items", items).build();
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                RsWithStatus rsWithStatus;
                block14: {
                    JsonWriter writer = Json.createWriter((OutputStream)out);
                    try {
                        writer.writeObject(json);
                        out.flush();
                        rsWithStatus = new RsWithStatus((Response)new RsWithBodyNoHeaders(out.toByteArray()), RsStatus.OK);
                        if (writer == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    writer.close();
                }
                return rsWithStatus;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }));
    }

    @Override
    public Response put(Headers headers, Publisher<ByteBuffer> body) {
        return new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
    }

    private CompletionStage<List<RegistrationPage>> pages() {
        return this.repository.versions(new PackageKeys(this.id)).thenApply(Versions::all).thenApply(versions -> {
            List<Object> pages = versions.isEmpty() ? Collections.emptyList() : Collections.singletonList(new RegistrationPage(this.repository, this.content, this.id, (List<NuspecField>)versions));
            return pages;
        });
    }
}

