/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.metadata;

import com.artipie.nuget.PackageIdentity;
import com.artipie.nuget.Repository;
import com.artipie.nuget.http.metadata.CompletionStages;
import com.artipie.nuget.http.metadata.ContentLocation;
import com.artipie.nuget.metadata.NuspecField;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;

final class RegistrationPage {
    private final Repository repository;
    private final ContentLocation content;
    private final NuspecField id;
    private final List<NuspecField> versions;

    RegistrationPage(Repository repository, ContentLocation content, NuspecField id, List<NuspecField> versions) {
        this.repository = repository;
        this.content = content;
        this.id = id;
        this.versions = versions;
    }

    public CompletionStage<JsonObject> json() {
        if (this.versions.isEmpty()) {
            throw new IllegalStateException(String.format("Registration page contains no versions: '%s'", this.id));
        }
        NuspecField lower = this.versions.get(0);
        NuspecField upper = this.versions.get(this.versions.size() - 1);
        return new CompletionStages(this.versions.stream().map(version -> this.leaf(new PackageIdentity(this.id, (NuspecField)version)))).all().thenApply(leafs -> {
            JsonArrayBuilder items = Json.createArrayBuilder();
            for (JsonObject leaf : leafs) {
                items.add((JsonValue)leaf);
            }
            return Json.createObjectBuilder().add("lower", lower.normalized()).add("upper", upper.normalized()).add("count", this.versions.size()).add("items", items).build();
        });
    }

    private CompletionStage<JsonObject> leaf(PackageIdentity identity) {
        return this.repository.nuspec(identity).thenApply(nuspec -> Json.createObjectBuilder().add("catalogEntry", Json.createObjectBuilder().add("id", nuspec.id().raw()).add("version", nuspec.version().normalized())).add("packageContent", this.content.url(identity).toString()).build());
    }
}

