/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.publish;

import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.Login;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.nuget.InvalidPackageException;
import com.artipie.nuget.PackageVersionAlreadyExistsException;
import com.artipie.nuget.Repository;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.publish.Multipart;
import com.artipie.scheduling.ArtifactEvent;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;

public final class PackagePublish
implements Route {
    private static final String REPO_TYPE = "nuget";
    private final Repository repository;
    private final String name;
    private final Optional<Queue<ArtifactEvent>> events;

    public PackagePublish(Repository repository, Optional<Queue<ArtifactEvent>> events, String name) {
        this.repository = repository;
        this.events = events;
        this.name = name;
    }

    @Override
    public String path() {
        return "/package";
    }

    @Override
    public Resource resource(String path) {
        return new NewPackage(this.repository, this.events, this.name);
    }

    public static final class NewPackage
    implements Resource {
        private final Repository repository;
        private final String name;
        private final Optional<Queue<ArtifactEvent>> events;

        public NewPackage(Repository repository, Optional<Queue<ArtifactEvent>> events, String name) {
            this.repository = repository;
            this.events = events;
            this.name = name;
        }

        @Override
        public Response get(Headers headers) {
            return new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
        }

        @Override
        public Response put(Headers headers, Publisher<ByteBuffer> body) {
            return new AsyncResponse(((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> new Multipart((Iterable<Map.Entry<String, String>>)headers, body).first()).thenCompose(this.repository::add)).handle((info, throwable) -> {
                RsStatus res;
                if (throwable == null) {
                    this.events.ifPresent(queue -> queue.add(new ArtifactEvent(PackagePublish.REPO_TYPE, this.name, new Login(headers).getValue(), info.packageName(), info.packageVersion(), info.zipSize())));
                    res = RsStatus.CREATED;
                } else {
                    res = NewPackage.toStatus(throwable.getCause());
                }
                return res;
            })).thenApply(RsWithStatus::new));
        }

        private static RsStatus toStatus(Throwable throwable) {
            RsStatus status = throwable instanceof InvalidPackageException ? RsStatus.BAD_REQUEST : (throwable instanceof PackageVersionAlreadyExistsException ? RsStatus.CONFLICT : RsStatus.INTERNAL_ERROR);
            return status;
        }
    }
}

